/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.topology.api.NetconfConnectorFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.HostBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPwBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.LoginPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfConnectorFactoryImpl
implements NetconfConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfConnectorFactoryImpl.class);
    private static final InstanceIdentifier<Topology> TOPOLOGY_PATH = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId("topology-netconf")));

    @Override
    public Node newInstance(DataBroker dataBroker, final String instanceName, String address, Integer port, String username, String password, Boolean tcpOnly, Boolean reconnectOnSchemaChange) {
        NodeId nodeId = new NodeId(instanceName);
        NodeKey nodeKey = new NodeKey(nodeId);
        LoginPw credentials = new LoginPwBuilder().setLoginPassword(new LoginPasswordBuilder().setUsername(username).setPassword(password).build()).build();
        Host host = HostBuilder.getDefaultInstance((String)address);
        PortNumber portNumber = new PortNumber(port);
        NetconfNode netconfNode = new NetconfNodeBuilder().setHost(host).setPort(portNumber).setCredentials((Credentials)credentials).setTcpOnly(tcpOnly).setReconnectOnChangedSchema(reconnectOnSchemaChange).build();
        Node node = new NodeBuilder().setNodeId(nodeId).withKey(nodeKey).addAugmentation(NetconfNode.class, (Augmentation)netconfNode).build();
        KeyedInstanceIdentifier nodePath = TOPOLOGY_PATH.child(Node.class, (Identifier)nodeKey);
        WriteTransaction transaction = dataBroker.newWriteOnlyTransaction();
        transaction.put(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)nodePath, (DataObject)node);
        transaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(@Nullable CommitInfo result) {
                LOG.debug("Node {} was successfully added to the topology", (Object)instanceName);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Node {} creation failed", (Object)instanceName, (Object)throwable);
            }
        }, MoreExecutors.directExecutor());
        return node;
    }
}

