/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.ModificationContextNodeBuilder;
import org.opendaylight.mdsal.dom.spi.shard.WriteableSubshardBoundaryNode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public abstract class ShardDataModificationFactoryBuilder<T>
extends ModificationContextNodeBuilder
implements Builder<T> {
    protected final DOMDataTreeIdentifier root;
    protected final Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards = new HashMap<DOMDataTreeIdentifier, ForeignShardModificationContext>();

    public ShardDataModificationFactoryBuilder(DOMDataTreeIdentifier root) {
        this.root = Objects.requireNonNull(root);
    }

    public void addSubshard(ForeignShardModificationContext value) {
        WriteableSubshardBoundaryNode leafNode = WriteableSubshardBoundaryNode.from((ForeignShardModificationContext)value);
        this.putNode(value.getIdentifier().getRootIdentifier(), leafNode);
    }

    public void addSubshard(DOMDataTreeIdentifier prefix, ForeignShardModificationContext value) {
        this.childShards.put(prefix, value);
    }

    private void putNode(YangInstanceIdentifier key, WriteableSubshardBoundaryNode subshardNode) {
        Iterator toBoundary = this.toRelative(key).getPathArguments().iterator();
        if (toBoundary.hasNext()) {
            ShardDataModificationFactoryBuilder current = this;
            while (true) {
                YangInstanceIdentifier.PathArgument nextArg = (YangInstanceIdentifier.PathArgument)toBoundary.next();
                if (!toBoundary.hasNext()) {
                    current.addBoundary(nextArg, subshardNode);
                    break;
                }
                current = current.getInterior(nextArg);
            }
        }
    }

    private YangInstanceIdentifier toRelative(YangInstanceIdentifier key) {
        return (YangInstanceIdentifier)key.relativeTo(this.root.getRootIdentifier()).get();
    }

    public abstract T build();
}

