/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ShardCanCommitCoordinationTask
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(ShardCanCommitCoordinationTask.class);
    private final DOMDataTreeIdentifier rootShardPrefix;
    private final Collection<DOMStoreThreePhaseCommitCohort> cohorts;

    public ShardCanCommitCoordinationTask(DOMDataTreeIdentifier rootShardPrefix, Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        this.rootShardPrefix = Objects.requireNonNull(rootShardPrefix);
        this.cohorts = Objects.requireNonNull(cohorts);
    }

    @Override
    public Boolean call() throws TransactionCommitFailedException {
        try {
            LOG.debug("Shard {}, canCommit started", (Object)this.rootShardPrefix);
            this.canCommitBlocking();
            return true;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Shard: {} Submit Error during phase CanCommit, starting Abort", (Object)this.rootShardPrefix, (Object)e);
            throw e;
        }
    }

    void canCommitBlocking() throws TransactionCommitFailedException {
        for (ListenableFuture<?> canCommit : this.canCommitAll()) {
            try {
                Boolean result = (Boolean)canCommit.get();
                if (result != null && result.booleanValue()) continue;
                throw new TransactionCommitFailedException("CanCommit failed, no detailed cause available.", new RpcError[0]);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TransactionCommitFailedException("CanCommit failed", (Throwable)e, new RpcError[0]);
            }
        }
    }

    private ListenableFuture<?>[] canCommitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.canCommit();
        }
        return ops;
    }
}

