/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDOMStoreTreeChangePublisher
extends AbstractDOMStoreTreeChangePublisher {
    private static final QueuedNotificationManager.BatchedInvoker<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> MANAGER_INVOKER = (listener, notifications) -> {
        DOMDataTreeChangeListener inst = (DOMDataTreeChangeListener)listener.getInstance();
        if (inst != null) {
            inst.onDataTreeChanged((Collection)ImmutableList.copyOf((Collection)notifications));
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreTreeChangePublisher.class);
    private final QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager;

    InMemoryDOMStoreTreeChangePublisher(ExecutorService listenerExecutor, int maxQueueSize) {
        this.notificationManager = QueuedNotificationManager.create((Executor)listenerExecutor, MANAGER_INVOKER, (int)maxQueueSize, (String)"DataTreeChangeListenerQueueMgr");
    }

    private InMemoryDOMStoreTreeChangePublisher(QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager) {
        this.notificationManager = notificationManager;
    }

    QueuedNotificationManager<?, ?> getNotificationManager() {
        return this.notificationManager;
    }

    protected void notifyListener(AbstractDOMDataTreeChangeListenerRegistration<?> registration, Collection<DataTreeCandidate> changes) {
        LOG.debug("Enqueueing candidates {} for registration {}", changes, registration);
        this.notificationManager.submitNotifications(registration, changes);
    }

    protected synchronized void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Closing registration {}", registration);
    }

    <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener, DataTreeSnapshot snapshot) {
        AbstractDOMDataTreeChangeListenerRegistration reg = this.registerTreeChangeListener(treeId, listener);
        Optional preExistingData = snapshot.readNode(YangInstanceIdentifier.EMPTY);
        if (!preExistingData.isPresent()) {
            listener.onInitialData();
            return reg;
        }
        NormalizedNode data = (NormalizedNode)preExistingData.get();
        if (treeId.isEmpty()) {
            Preconditions.checkState((boolean)(data instanceof DataContainerNode), (String)"Unexpected root node %s", (Object)data);
            if (((DataContainerNode)data).getValue().isEmpty()) {
                listener.onInitialData();
                return reg;
            }
        }
        DataTreeCandidate candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.EMPTY, (NormalizedNode)data);
        InMemoryDOMStoreTreeChangePublisher publisher = new InMemoryDOMStoreTreeChangePublisher(this.notificationManager);
        publisher.registerTreeChangeListener(treeId, listener);
        if (!publisher.publishChange(candidate)) {
            listener.onInitialData();
        }
        return reg;
    }

    synchronized boolean publishChange(@NonNull DataTreeCandidate candidate) {
        return this.processCandidateTree(candidate);
    }
}

