/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStoreConfigProperties;
import org.opendaylight.yangtools.util.concurrent.SpecialExecutors;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

@NonNullByDefault
public final class InMemoryDOMDataStoreFactory {
    private InMemoryDOMDataStoreFactory() {
    }

    public static InMemoryDOMDataStore create(String name, @Nullable DOMSchemaService schemaService) {
        return InMemoryDOMDataStoreFactory.create(name, InMemoryDOMDataStoreConfigProperties.getDefault(), schemaService);
    }

    public static InMemoryDOMDataStore create(String name, InMemoryDOMDataStoreConfigProperties properties, @Nullable DOMSchemaService schemaService) {
        ExecutorService dataChangeListenerExecutor = InMemoryDOMDataStoreFactory.createExecutorService(name, properties);
        InMemoryDOMDataStore dataStore = new InMemoryDOMDataStore(name, dataChangeListenerExecutor, properties.getMaxDataChangeListenerQueueSize(), properties.getDebugTransactions());
        if (schemaService != null) {
            schemaService.registerSchemaContextListener((SchemaContextListener)dataStore);
        }
        return dataStore;
    }

    private static ExecutorService createExecutorService(String name, InMemoryDOMDataStoreConfigProperties props) {
        return SpecialExecutors.newBlockingBoundedFastThreadPool((int)props.getMaxDataChangeExecutorPoolSize(), (int)props.getMaxDataChangeExecutorQueueSize(), (String)(name + "-DCL"), InMemoryDOMDataStoreFactory.class);
    }
}

