/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignShardThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignShardThreePhaseCommitCohort.class);
    private static final ListenableFuture<Boolean> SUCCESS_VALIDATE = Futures.immediateFuture((Object)Boolean.TRUE);
    private static final ListenableFuture<Void> SUCCESS_FUTURE = Futures.immediateFuture(null);
    private final DOMDataTreeIdentifier prefix;
    private final ForeignShardModificationContext shard;

    public ForeignShardThreePhaseCommitCohort(DOMDataTreeIdentifier prefix, ForeignShardModificationContext shard) {
        this.prefix = Objects.requireNonNull(prefix);
        this.shard = Objects.requireNonNull(shard);
    }

    public ListenableFuture<Boolean> canCommit() {
        LOG.debug("Validating transaction on foreign shard {}", (Object)this.prefix);
        return this.shard.isModified() ? this.shard.validate() : SUCCESS_VALIDATE;
    }

    public ListenableFuture<Void> preCommit() {
        LOG.debug("Preparing transaction on foreign shard {}", (Object)this.prefix);
        return this.shard.isModified() ? this.shard.prepare() : SUCCESS_FUTURE;
    }

    public ListenableFuture<Void> abort() {
        LOG.debug("Aborting transaction of foreign shard {}", (Object)this.prefix);
        this.shard.closeForeignTransaction();
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> commit() {
        LOG.debug("Submitting transaction on foreign shard {}", (Object)this.prefix);
        return this.shard.isModified() ? this.shard.submit() : SUCCESS_FUTURE;
    }
}

