/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.messaging;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;
import org.opendaylight.yangtools.concepts.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SlicedMessageState<T>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SlicedMessageState.class);
    static final int FIRST_SLICE_INDEX = 1;
    static final int INITIAL_SLICE_HASH_CODE = -1;
    private final Identifier identifier;
    private final int messageSliceSize;
    private final FileBackedOutputStream fileBackedStream;
    private final T replyTarget;
    private final ByteSource messageBytes;
    private final int totalSlices;
    private final long totalMessageSize;
    private final int maxRetries;
    private final Consumer<Throwable> onFailureCallback;
    private final String logContext;
    private int currentByteOffset = 0;
    private int currentSliceIndex = 0;
    private int lastSliceHashCode = -1;
    private int currentSliceHashCode = -1;
    private int tryCount = 1;
    private InputStream messageInputStream;

    public SlicedMessageState(Identifier identifier, FileBackedOutputStream fileBackedStream, int messageSliceSize, int maxRetries, T replyTarget, Consumer<Throwable> onFailureCallback, String logContext) throws IOException {
        this.identifier = identifier;
        this.fileBackedStream = fileBackedStream;
        this.messageSliceSize = messageSliceSize;
        this.maxRetries = maxRetries;
        this.replyTarget = replyTarget;
        this.onFailureCallback = onFailureCallback;
        this.logContext = logContext;
        this.messageBytes = fileBackedStream.asByteSource();
        this.totalMessageSize = this.messageBytes.size();
        this.messageInputStream = this.messageBytes.openStream();
        this.totalSlices = (int)(this.totalMessageSize / (long)messageSliceSize + (long)(this.totalMessageSize % (long)messageSliceSize > 0L ? 1 : 0));
        LOG.debug("{}: Message size: {} bytes, total slices to send: {}", new Object[]{logContext, this.totalMessageSize, this.totalSlices});
    }

    public int getCurrentSliceIndex() {
        return this.currentSliceIndex;
    }

    public int getLastSliceHashCode() {
        return this.lastSliceHashCode;
    }

    public int getTotalSlices() {
        return this.totalSlices;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public T getReplyTarget() {
        return this.replyTarget;
    }

    public Consumer<Throwable> getOnFailureCallback() {
        return this.onFailureCallback;
    }

    public boolean canRetry() {
        return this.tryCount <= this.maxRetries;
    }

    public boolean isLastSlice(int index) {
        return this.totalSlices == index;
    }

    public byte[] getNextSlice() throws IOException {
        ++this.currentSliceIndex;
        int start = this.currentSliceIndex == 1 ? 0 : this.incrementByteOffset();
        int size = (long)this.messageSliceSize > this.totalMessageSize ? (int)this.totalMessageSize : ((long)(start + this.messageSliceSize) > this.totalMessageSize ? (int)(this.totalMessageSize - (long)start) : this.messageSliceSize);
        LOG.debug("{}: getNextSlice: total size: {}, offset: {}, size: {}, index: {}", new Object[]{this.logContext, this.totalMessageSize, start, size, this.currentSliceIndex});
        byte[] nextSlice = new byte[size];
        int numRead = this.messageInputStream.read(nextSlice);
        if (numRead != size) {
            throw new IOException(String.format("The # of bytes read from the input stream, %d, does not match the expected # %d", numRead, size));
        }
        this.lastSliceHashCode = this.currentSliceHashCode;
        this.currentSliceHashCode = Arrays.hashCode(nextSlice);
        return nextSlice;
    }

    public void reset() throws IOException {
        this.closeStream();
        ++this.tryCount;
        this.currentByteOffset = 0;
        this.currentSliceIndex = 0;
        this.lastSliceHashCode = -1;
        this.currentSliceHashCode = -1;
        this.messageInputStream = this.messageBytes.openStream();
    }

    private int incrementByteOffset() {
        this.currentByteOffset += this.messageSliceSize;
        return this.currentByteOffset;
    }

    private void closeStream() {
        if (this.messageInputStream != null) {
            try {
                this.messageInputStream.close();
            }
            catch (IOException e) {
                LOG.warn("{}: Error closing message stream", (Object)this.logContext, (Object)e);
            }
            this.messageInputStream = null;
        }
    }

    @Override
    public void close() {
        this.closeStream();
        this.fileBackedStream.cleanup();
    }
}

