/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.transformer;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.NormalizedNodeBuilderWrapper;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNormalizedNodePruner
implements NormalizedNodeStreamWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNormalizedNodePruner.class);
    private final Deque<NormalizedNodeBuilderWrapper> stack = new ArrayDeque<NormalizedNodeBuilderWrapper>();
    private final DataSchemaContextTree tree;
    private DataSchemaContextNode<?> nodePathSchemaNode;
    private State state = State.UNITIALIZED;
    NormalizedNode<?, ?> normalizedNode;

    AbstractNormalizedNodePruner(DataSchemaContextTree tree) {
        this.tree = Objects.requireNonNull(tree);
    }

    AbstractNormalizedNodePruner(SchemaContext schemaContext) {
        this(DataSchemaContextTree.from((SchemaContext)schemaContext));
    }

    final DataSchemaContextTree getTree() {
        return this.tree;
    }

    final void initialize(YangInstanceIdentifier nodePath) {
        this.nodePathSchemaNode = this.tree.findChild(nodePath).orElse(null);
        this.normalizedNode = null;
        this.stack.clear();
        this.state = State.OPEN;
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Object value) {
        this.checkNotSealed();
        NormalizedNodeBuilderWrapper parent = this.stack.peek();
        LeafNode leafNode = (LeafNode)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nodeIdentifier).withValue(value).build();
        if (parent != null) {
            if (AbstractNormalizedNodePruner.hasValidSchema(nodeIdentifier.getNodeType(), parent)) {
                parent.builder().addChild((NormalizedNode)leafNode);
            }
        } else {
            if (this.nodePathSchemaNode != null) {
                this.normalizedNode = leafNode;
            }
            this.state = State.CLOSED;
        }
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.leafSetBuilder().withNodeIdentifier(nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int str) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.orderedLeafSetBuilder().withNodeIdentifier(nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void leafSetEntryNode(QName name, Object value) {
        this.checkNotSealed();
        NormalizedNodeBuilderWrapper parent = this.stack.peek();
        if (parent != null) {
            if (AbstractNormalizedNodePruner.hasValidSchema(name, parent)) {
                parent.builder().addChild(Builders.leafSetEntryBuilder().withValue(value).withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(parent.nodeType(), value)).build());
            }
        } else {
            if (this.nodePathSchemaNode != null) {
                this.normalizedNode = Builders.leafSetEntryBuilder().withValue(value).withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(name, value)).build();
            }
            this.state = State.CLOSED;
        }
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.unkeyedListBuilder().withNodeIdentifier(nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.unkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.mapBuilder().withNodeIdentifier(nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates nodeIdentifierWithPredicates, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nodeIdentifierWithPredicates), (YangInstanceIdentifier.PathArgument)nodeIdentifierWithPredicates);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.orderedMapBuilder().withNodeIdentifier(nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nodeIdentifier), (YangInstanceIdentifier.PathArgument)nodeIdentifier);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifier) {
        this.addBuilder((NormalizedNodeContainerBuilder<?, ?, ?, ?>)Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)augmentationIdentifier), (YangInstanceIdentifier.PathArgument)augmentationIdentifier);
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Object value) {
        this.checkNotSealed();
        NormalizedNodeBuilderWrapper parent = this.stack.peek();
        AnyXmlNode anyXmlNode = (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nodeIdentifier).withValue((Object)((DOMSource)value)).build();
        if (parent != null) {
            if (AbstractNormalizedNodePruner.hasValidSchema(nodeIdentifier.getNodeType(), parent)) {
                parent.builder().addChild((NormalizedNode)anyXmlNode);
            }
        } else {
            if (this.nodePathSchemaNode != null) {
                this.normalizedNode = anyXmlNode;
            }
            this.state = State.CLOSED;
        }
    }

    public void endNode() {
        NormalizedNodeBuilderWrapper child;
        this.checkNotSealed();
        try {
            child = this.stack.pop();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("endNode called on an empty stack", e);
        }
        if (child.getSchema() == null) {
            LOG.debug("Schema not found for {}", (Object)child.identifier());
            if (this.stack.isEmpty()) {
                this.normalizedNode = null;
                this.state = State.CLOSED;
            }
            return;
        }
        NormalizedNode newNode = child.builder().build();
        NormalizedNodeBuilderWrapper parent = this.stack.peek();
        if (parent == null) {
            this.normalizedNode = newNode;
            this.state = State.CLOSED;
        } else {
            parent.builder().addChild(newNode);
        }
    }

    public void close() {
        this.state = State.CLOSED;
        this.stack.clear();
    }

    public void flush() {
    }

    public final Optional<NormalizedNode<?, ?>> getResult() {
        Preconditions.checkState((this.state == State.CLOSED ? 1 : 0) != 0, (String)"Cannot get result in state %s", (Object)((Object)this.state));
        return Optional.ofNullable(this.normalizedNode);
    }

    private void checkNotSealed() {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0, (String)"Illegal operation in state %s", (Object)((Object)this.state));
    }

    private static boolean hasValidSchema(QName name, NormalizedNodeBuilderWrapper parent) {
        boolean valid;
        DataSchemaContextNode<?> parentSchema = parent.getSchema();
        boolean bl = valid = parentSchema != null && parentSchema.getChild(name) != null;
        if (!valid) {
            LOG.debug("Schema not found for {}", (Object)name);
        }
        return valid;
    }

    private NormalizedNodeBuilderWrapper addBuilder(NormalizedNodeContainerBuilder<?, ?, ?, ?> builder, YangInstanceIdentifier.PathArgument identifier) {
        DataSchemaContextNode<?> parentSchema;
        this.checkNotSealed();
        NormalizedNodeBuilderWrapper parent = this.stack.peek();
        Object schemaNode = parent != null ? ((parentSchema = parent.getSchema()) == null ? null : parentSchema.getChild(identifier)) : this.nodePathSchemaNode;
        NormalizedNodeBuilderWrapper wrapper = new NormalizedNodeBuilderWrapper(builder, identifier, (DataSchemaContextNode<?>)schemaNode);
        this.stack.push(wrapper);
        return wrapper;
    }

    static enum State {
        UNITIALIZED,
        OPEN,
        CLOSED;

    }
}

