/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class ValueTypes {
    public static final int STRING_BYTES_LENGTH_THRESHOLD = 8191;
    public static final byte SHORT_TYPE = 1;
    public static final byte BYTE_TYPE = 2;
    public static final byte INT_TYPE = 3;
    public static final byte LONG_TYPE = 4;
    public static final byte BOOL_TYPE = 5;
    public static final byte QNAME_TYPE = 6;
    public static final byte BITS_TYPE = 7;
    public static final byte YANG_IDENTIFIER_TYPE = 8;
    public static final byte STRING_TYPE = 9;
    public static final byte BIG_INTEGER_TYPE = 10;
    public static final byte BIG_DECIMAL_TYPE = 11;
    public static final byte BINARY_TYPE = 12;
    @Deprecated
    public static final byte NULL_TYPE = 13;
    public static final byte STRING_BYTES_TYPE = 14;
    public static final byte EMPTY_TYPE = 15;
    private static final Map<Class<?>, Byte> TYPES;

    private ValueTypes() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static byte getSerializableType(Object node) {
        Objects.requireNonNull(node);
        Byte type = TYPES.get(node.getClass());
        if (type != null) {
            if (type == 9 && ((String)node).length() >= 8191) {
                return 14;
            }
            return type;
        }
        if (node instanceof Set) {
            return 7;
        }
        if (node instanceof YangInstanceIdentifier) {
            return 8;
        }
        throw new IllegalArgumentException("Unknown value type " + node.getClass().getSimpleName());
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put(String.class, (Object)9);
        b.put(Byte.class, (Object)2);
        b.put(Integer.class, (Object)3);
        b.put(Long.class, (Object)4);
        b.put(Boolean.class, (Object)5);
        b.put(QName.class, (Object)6);
        b.put(Short.class, (Object)1);
        b.put(BigInteger.class, (Object)10);
        b.put(BigDecimal.class, (Object)11);
        b.put(byte[].class, (Object)12);
        b.put(Empty.class, (Object)15);
        TYPES = b.build();
    }
}

