/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class PathArgumentTypes {
    public static final byte AUGMENTATION_IDENTIFIER = 1;
    public static final byte NODE_IDENTIFIER = 2;
    public static final byte NODE_IDENTIFIER_WITH_VALUE = 3;
    public static final byte NODE_IDENTIFIER_WITH_PREDICATES = 4;
    private static final Map<Class<?>, Byte> CLASS_TO_ENUM_MAP = ImmutableMap.builder().put(YangInstanceIdentifier.AugmentationIdentifier.class, (Object)1).put(YangInstanceIdentifier.NodeIdentifier.class, (Object)2).put(YangInstanceIdentifier.NodeIdentifierWithPredicates.class, (Object)4).put(YangInstanceIdentifier.NodeWithValue.class, (Object)3).build();

    private PathArgumentTypes() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static byte getSerializablePathArgumentType(YangInstanceIdentifier.PathArgument pathArgument) {
        Byte type = CLASS_TO_ENUM_MAP.get(pathArgument.getClass());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type of PathArgument = %s", (Object)pathArgument);
        return type;
    }
}

