/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.controller.cluster.datastore.node.utils.QNameFactory;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.InvalidNormalizedNodeStreamException;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NormalizedNodeInputStreamReader
implements NormalizedNodeDataInput {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeInputStreamReader.class);
    private static final String REVISION_ARG = "?revision=";
    private final DataInput input;
    private final List<String> codedStringMap = new ArrayList<String>();
    private QName lastLeafSetQName;
    private NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, Object, LeafNode<Object>> leafBuilder;
    private NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeWithValue, Object, LeafSetEntryNode<Object>> leafSetEntryBuilder;
    private final StringBuilder reusableStringBuilder = new StringBuilder(50);
    private boolean readSignatureMarker = true;

    NormalizedNodeInputStreamReader(DataInput input, boolean versionChecked) {
        this.input = (DataInput)Preconditions.checkNotNull((Object)input);
        this.readSignatureMarker = !versionChecked;
    }

    @Override
    public NormalizedNode<?, ?> readNormalizedNode() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.readNormalizedNodeInternal();
    }

    private void readSignatureMarkerAndVersionIfNeeded() throws IOException {
        if (this.readSignatureMarker) {
            this.readSignatureMarker = false;
            byte marker = this.input.readByte();
            if (marker != -85) {
                throw new InvalidNormalizedNodeStreamException(String.format("Invalid signature marker: %d", marker));
            }
            short version = this.input.readShort();
            if (version != 1) {
                throw new InvalidNormalizedNodeStreamException(String.format("Unhandled stream version %s", version));
            }
        }
    }

    private NormalizedNode<?, ?> readNormalizedNodeInternal() throws IOException {
        byte nodeType = this.input.readByte();
        if (nodeType == 13) {
            LOG.trace("End node reached. return");
            this.lastLeafSetQName = null;
            return null;
        }
        switch (nodeType) {
            case 11: {
                YangInstanceIdentifier.AugmentationIdentifier augIdentifier = new YangInstanceIdentifier.AugmentationIdentifier(this.readQNameSet());
                LOG.trace("Reading augmentation node {} ", (Object)augIdentifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)augIdentifier)).build();
            }
            case 3: {
                QName name = this.lastLeafSetQName;
                if (name == null) {
                    name = this.readQName();
                }
                Object value = this.readObject();
                YangInstanceIdentifier.NodeWithValue leafIdentifier = new YangInstanceIdentifier.NodeWithValue(name, value);
                LOG.trace("Reading leaf set entry node {}, value {}", (Object)leafIdentifier, value);
                return this.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)leafIdentifier).withValue(value).build();
            }
            case 8: {
                YangInstanceIdentifier.NodeIdentifierWithPredicates entryIdentifier = this.readNormalizedNodeWithPredicates();
                LOG.trace("Reading map entry node {} ", (Object)entryIdentifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)entryIdentifier)).build();
            }
        }
        return this.readNodeIdentifierDependentNode(nodeType, new YangInstanceIdentifier.NodeIdentifier(this.readQName()));
    }

    private NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, Object, LeafNode<Object>> leafBuilder() {
        if (this.leafBuilder == null) {
            this.leafBuilder = Builders.leafBuilder();
        }
        return this.leafBuilder;
    }

    private NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeWithValue, Object, LeafSetEntryNode<Object>> leafSetEntryBuilder() {
        if (this.leafSetEntryBuilder == null) {
            this.leafSetEntryBuilder = Builders.leafSetEntryBuilder();
        }
        return this.leafSetEntryBuilder;
    }

    private NormalizedNode<?, ?> readNodeIdentifierDependentNode(byte nodeType, YangInstanceIdentifier.NodeIdentifier identifier) throws IOException {
        switch (nodeType) {
            case 1: {
                LOG.trace("Read leaf node {}", (Object)identifier);
                return this.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier).withValue(this.readObject()).build();
            }
            case 12: {
                LOG.trace("Read xml node");
                return Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier).withValue((Object)this.readDOMSource()).build();
            }
            case 7: {
                LOG.trace("Read map node {}", (Object)identifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.mapBuilder().withNodeIdentifier(identifier)).build();
            }
            case 10: {
                LOG.trace("Read choice node {}", (Object)identifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier)).build();
            }
            case 9: {
                LOG.trace("Reading ordered map node {}", (Object)identifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.orderedMapBuilder().withNodeIdentifier(identifier)).build();
            }
            case 5: {
                LOG.trace("Read unkeyed list node {}", (Object)identifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.unkeyedListBuilder().withNodeIdentifier(identifier)).build();
            }
            case 6: {
                LOG.trace("Read unkeyed list item node {}", (Object)identifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.unkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier)).build();
            }
            case 4: {
                LOG.trace("Read container node {}", (Object)identifier);
                return this.addDataContainerChildren((NormalizedNodeContainerBuilder)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)identifier)).build();
            }
            case 2: {
                LOG.trace("Read leaf set node {}", (Object)identifier);
                return this.addLeafSetChildren(identifier.getNodeType(), (ListNodeBuilder<Object, LeafSetEntryNode<Object>>)Builders.leafSetBuilder().withNodeIdentifier(identifier)).build();
            }
            case 14: {
                LOG.trace("Read ordered leaf set node {}", (Object)identifier);
                return this.addLeafSetChildren(identifier.getNodeType(), (ListNodeBuilder<Object, LeafSetEntryNode<Object>>)Builders.orderedLeafSetBuilder().withNodeIdentifier(identifier)).build();
            }
        }
        return null;
    }

    private DOMSource readDOMSource() throws IOException {
        String xml = this.readObject().toString();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Element node = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml))).getDocumentElement();
            return new DOMSource(node);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Error parsing XML: " + xml, e);
        }
    }

    private QName readQName() throws IOException {
        String localName = this.readCodedString();
        String namespace = this.readCodedString();
        String revision = this.readCodedString();
        String qname = !Strings.isNullOrEmpty((String)revision) ? this.reusableStringBuilder.append('(').append(namespace).append(REVISION_ARG).append(revision).append(')').append(localName).toString() : this.reusableStringBuilder.append('(').append(namespace).append(')').append(localName).toString();
        this.reusableStringBuilder.delete(0, this.reusableStringBuilder.length());
        return QNameFactory.create(qname);
    }

    private String readCodedString() throws IOException {
        byte valueType = this.input.readByte();
        switch (valueType) {
            case 3: {
                return null;
            }
            case 1: {
                int code = this.input.readInt();
                try {
                    return this.codedStringMap.get(code);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException("String code " + code + " was not found", e);
                }
            }
            case 2: {
                String value = this.input.readUTF().intern();
                this.codedStringMap.add(value);
                return value;
            }
        }
        throw new IOException("Unhandled string value type " + valueType);
    }

    private Set<QName> readQNameSet() throws IOException {
        int count = this.input.readInt();
        HashSet<QName> children = new HashSet<QName>(count);
        for (int i = 0; i < count; ++i) {
            children.add(this.readQName());
        }
        return children;
    }

    private YangInstanceIdentifier.NodeIdentifierWithPredicates readNormalizedNodeWithPredicates() throws IOException {
        QName qname = this.readQName();
        int count = this.input.readInt();
        switch (count) {
            case 0: {
                return new YangInstanceIdentifier.NodeIdentifierWithPredicates(qname);
            }
            case 1: {
                return new YangInstanceIdentifier.NodeIdentifierWithPredicates(qname, this.readQName(), this.readObject());
            }
        }
        ImmutableList.Builder keys = ImmutableList.builderWithExpectedSize((int)count);
        Object[] values = new Object[count];
        for (int i = 0; i < count; ++i) {
            keys.add((Object)this.readQName());
            values[i] = this.readObject();
        }
        return new YangInstanceIdentifier.NodeIdentifierWithPredicates(qname, ImmutableOffsetMapTemplate.ordered((Collection)keys.build()).instantiateWithValues(values));
    }

    private Object readObject() throws IOException {
        byte objectType = this.input.readByte();
        switch (objectType) {
            case 7: {
                return this.readObjSet();
            }
            case 5: {
                return this.input.readBoolean();
            }
            case 2: {
                return this.input.readByte();
            }
            case 3: {
                return this.input.readInt();
            }
            case 4: {
                return this.input.readLong();
            }
            case 6: {
                return this.readQName();
            }
            case 1: {
                return this.input.readShort();
            }
            case 9: {
                return this.input.readUTF();
            }
            case 14: {
                return this.readStringBytes();
            }
            case 11: {
                return new BigDecimal(this.input.readUTF());
            }
            case 10: {
                return new BigInteger(this.input.readUTF());
            }
            case 12: {
                byte[] bytes = new byte[this.input.readInt()];
                this.input.readFully(bytes);
                return bytes;
            }
            case 8: {
                return this.readYangInstanceIdentifierInternal();
            }
            case 13: 
            case 15: {
                return Empty.getInstance();
            }
        }
        return null;
    }

    private String readStringBytes() throws IOException {
        byte[] bytes = new byte[this.input.readInt()];
        this.input.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public SchemaPath readSchemaPath() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        boolean absolute = this.input.readBoolean();
        int size = this.input.readInt();
        ImmutableList.Builder qnames = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            qnames.add((Object)this.readQName());
        }
        return SchemaPath.create((Iterable)qnames.build(), (boolean)absolute);
    }

    @Override
    public YangInstanceIdentifier readYangInstanceIdentifier() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.readYangInstanceIdentifierInternal();
    }

    private YangInstanceIdentifier readYangInstanceIdentifierInternal() throws IOException {
        int size = this.input.readInt();
        ImmutableList.Builder pathArguments = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            pathArguments.add((Object)this.readPathArgument());
        }
        return YangInstanceIdentifier.create((Iterable)pathArguments.build());
    }

    private Set<String> readObjSet() throws IOException {
        int count = this.input.readInt();
        HashSet<String> children = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            children.add(this.readCodedString());
        }
        return children;
    }

    @Override
    public YangInstanceIdentifier.PathArgument readPathArgument() throws IOException {
        byte type = this.input.readByte();
        switch (type) {
            case 1: {
                return new YangInstanceIdentifier.AugmentationIdentifier(this.readQNameSet());
            }
            case 2: {
                return new YangInstanceIdentifier.NodeIdentifier(this.readQName());
            }
            case 4: {
                return this.readNormalizedNodeWithPredicates();
            }
            case 3: {
                return new YangInstanceIdentifier.NodeWithValue(this.readQName(), this.readObject());
            }
        }
        return null;
    }

    private ListNodeBuilder<Object, LeafSetEntryNode<Object>> addLeafSetChildren(QName nodeType, ListNodeBuilder<Object, LeafSetEntryNode<Object>> builder) throws IOException {
        LOG.trace("Reading children of leaf set");
        this.lastLeafSetQName = nodeType;
        LeafSetEntryNode child = (LeafSetEntryNode)this.readNormalizedNodeInternal();
        while (child != null) {
            builder.withChild(child);
            child = (LeafSetEntryNode)this.readNormalizedNodeInternal();
        }
        return builder;
    }

    private NormalizedNodeContainerBuilder addDataContainerChildren(NormalizedNodeContainerBuilder builder) throws IOException {
        LOG.trace("Reading data container (leaf nodes) nodes");
        NormalizedNode<?, ?> child = this.readNormalizedNodeInternal();
        while (child != null) {
            builder.addChild(child);
            child = this.readNormalizedNodeInternal();
        }
        return builder;
    }

    @Override
    public void readFully(byte[] value) throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        this.input.readFully(value);
    }

    @Override
    public void readFully(byte[] str, int off, int len) throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        this.input.readFully(str, off, len);
    }

    @Override
    public int skipBytes(int num) throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.skipBytes(num);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        this.readSignatureMarkerAndVersionIfNeeded();
        return this.input.readUTF();
    }
}

