/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.PathArgumentTypes;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.ValueTypes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNormalizedNodeDataOutput
implements NormalizedNodeDataOutput,
NormalizedNodeStreamWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNormalizedNodeDataOutput.class);
    private final DataOutput output;
    private NormalizedNodeWriter normalizedNodeWriter;
    private boolean headerWritten;
    private QName lastLeafSetQName;

    AbstractNormalizedNodeDataOutput(DataOutput output) {
        this.output = (DataOutput)Preconditions.checkNotNull((Object)output);
    }

    private void ensureHeaderWritten() throws IOException {
        if (!this.headerWritten) {
            this.output.writeByte(-85);
            this.output.writeShort(this.streamVersion());
            this.headerWritten = true;
        }
    }

    protected abstract short streamVersion();

    protected abstract void writeQName(QName var1) throws IOException;

    protected abstract void writeString(String var1) throws IOException;

    @Override
    public final void write(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.write(value);
    }

    @Override
    public final void write(byte[] bytes) throws IOException {
        this.ensureHeaderWritten();
        this.output.write(bytes);
    }

    @Override
    public final void write(byte[] bytes, int off, int len) throws IOException {
        this.ensureHeaderWritten();
        this.output.write(bytes, off, len);
    }

    @Override
    public final void writeBoolean(boolean value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeBoolean(value);
    }

    @Override
    public final void writeByte(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeByte(value);
    }

    @Override
    public final void writeShort(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeShort(value);
    }

    @Override
    public final void writeChar(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeChar(value);
    }

    @Override
    public final void writeInt(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeInt(value);
    }

    @Override
    public final void writeLong(long value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeLong(value);
    }

    @Override
    public final void writeFloat(float value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeFloat(value);
    }

    @Override
    public final void writeDouble(double value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeDouble(value);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeBytes(str);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeChars(str);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeUTF(str);
    }

    private NormalizedNodeWriter normalizedNodeWriter() {
        if (this.normalizedNodeWriter == null) {
            this.normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)this);
        }
        return this.normalizedNodeWriter;
    }

    @Override
    public void writeNormalizedNode(NormalizedNode<?, ?> node) throws IOException {
        this.ensureHeaderWritten();
        this.normalizedNodeWriter().write(node);
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Writing a new leaf node");
        this.startNode(name.getNodeType(), (byte)1);
        this.writeObject(value);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new leaf set");
        this.lastLeafSetQName = name.getNodeType();
        this.startNode(name.getNodeType(), (byte)2);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new ordered leaf set");
        this.lastLeafSetQName = name.getNodeType();
        this.startNode(name.getNodeType(), (byte)14);
    }

    public void leafSetEntryNode(QName name, Object value) throws IOException, IllegalArgumentException {
        LOG.trace("Writing a new leaf set entry node");
        this.output.writeByte(3);
        if (this.lastLeafSetQName == null) {
            this.writeQName(name);
        }
        this.writeObject(value);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new container node");
        this.startNode(name.getNodeType(), (byte)4);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new yang modeled anyXml node");
        this.startNode(name.getNodeType(), (byte)15);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new unkeyed list");
        this.startNode(name.getNodeType(), (byte)5);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalStateException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new unkeyed list item");
        this.startNode(name.getNodeType(), (byte)6);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new map node");
        this.startNode(name.getNodeType(), (byte)7);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)identifier, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new map entry node");
        this.startNode(identifier.getNodeType(), (byte)8);
        this.writeKeyValueMap(identifier.getKeyValues());
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new ordered map node");
        this.startNode(name.getNodeType(), (byte)9);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new choice node");
        this.startNode(name.getNodeType(), (byte)10);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)identifier, (Object)"Node identifier should not be null");
        LOG.trace("Starting a new augmentation node");
        this.output.writeByte(11);
        this.writeQNameSet(identifier.getPossibleChildNames());
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)name, (Object)"Node identifier should not be null");
        LOG.trace("Writing any xml node");
        this.startNode(name.getNodeType(), (byte)12);
        try {
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory.newInstance().newTransformer().transform((DOMSource)value, xmlOutput);
            this.writeObject(xmlOutput.getWriter().toString());
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            throw new IOException("Error writing anyXml", e);
        }
    }

    public void endNode() throws IOException, IllegalStateException {
        LOG.trace("Ending the node");
        this.lastLeafSetQName = null;
        this.output.writeByte(13);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this.output instanceof OutputStream) {
            ((OutputStream)((Object)this.output)).flush();
        }
    }

    private void startNode(QName qname, byte nodeType) throws IOException {
        Preconditions.checkNotNull((Object)qname, (Object)"QName of node identifier should not be null.");
        this.ensureHeaderWritten();
        this.output.writeByte(nodeType);
        this.writeQName(qname);
    }

    private void writeObjSet(Set<?> set) throws IOException {
        this.output.writeInt(set.size());
        for (Object o : set) {
            Preconditions.checkArgument((boolean)(o instanceof String), (String)"Expected value type to be String but was %s (%s)", o.getClass(), o);
            this.writeString((String)o);
        }
    }

    @Override
    public void writeSchemaPath(SchemaPath path) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeBoolean(path.isAbsolute());
        List qnames = path.getPath();
        this.output.writeInt(qnames.size());
        for (QName qname : qnames) {
            this.writeQName(qname);
        }
    }

    @Override
    public void writeYangInstanceIdentifier(YangInstanceIdentifier identifier) throws IOException {
        this.ensureHeaderWritten();
        this.writeYangInstanceIdentifierInternal(identifier);
    }

    private void writeYangInstanceIdentifierInternal(YangInstanceIdentifier identifier) throws IOException {
        List pathArguments = identifier.getPathArguments();
        this.output.writeInt(pathArguments.size());
        for (YangInstanceIdentifier.PathArgument pathArgument : pathArguments) {
            this.writePathArgument(pathArgument);
        }
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The casts in the switch clauses are indirectly confirmed via the determination of 'type'.")
    public void writePathArgument(YangInstanceIdentifier.PathArgument pathArgument) throws IOException {
        byte type = PathArgumentTypes.getSerializablePathArgumentType(pathArgument);
        this.output.writeByte(type);
        switch (type) {
            case 2: {
                YangInstanceIdentifier.NodeIdentifier nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)pathArgument;
                this.writeQName(nodeIdentifier.getNodeType());
                break;
            }
            case 4: {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nodeIdentifierWithPredicates = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
                this.writeQName(nodeIdentifierWithPredicates.getNodeType());
                this.writeKeyValueMap(nodeIdentifierWithPredicates.getKeyValues());
                break;
            }
            case 3: {
                YangInstanceIdentifier.NodeWithValue nodeWithValue = (YangInstanceIdentifier.NodeWithValue)pathArgument;
                this.writeQName(nodeWithValue.getNodeType());
                this.writeObject(nodeWithValue.getValue());
                break;
            }
            case 1: {
                YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifier = (YangInstanceIdentifier.AugmentationIdentifier)pathArgument;
                this.writeQNameSet(augmentationIdentifier.getPossibleChildNames());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown node identifier type is found : " + pathArgument.getClass().toString());
            }
        }
    }

    private void writeKeyValueMap(Map<QName, Object> keyValueMap) throws IOException {
        if (keyValueMap != null && !keyValueMap.isEmpty()) {
            this.output.writeInt(keyValueMap.size());
            for (Map.Entry<QName, Object> entry : keyValueMap.entrySet()) {
                this.writeQName(entry.getKey());
                this.writeObject(entry.getValue());
            }
        } else {
            this.output.writeInt(0);
        }
    }

    private void writeQNameSet(Set<QName> children) throws IOException {
        if (children != null && !children.isEmpty()) {
            this.output.writeInt(children.size());
            for (QName qname : children) {
                this.writeQName(qname);
            }
        } else {
            LOG.debug("augmentation node does not have any child");
            this.output.writeInt(0);
        }
    }

    private void writeObject(Object value) throws IOException {
        byte type = ValueTypes.getSerializableType(value);
        this.output.writeByte(type);
        switch (type) {
            case 5: {
                this.output.writeBoolean((Boolean)value);
                break;
            }
            case 6: {
                this.writeQName((QName)value);
                break;
            }
            case 3: {
                this.output.writeInt((Integer)value);
                break;
            }
            case 2: {
                this.output.writeByte(((Byte)value).byteValue());
                break;
            }
            case 4: {
                this.output.writeLong((Long)value);
                break;
            }
            case 1: {
                this.output.writeShort(((Short)value).shortValue());
                break;
            }
            case 7: {
                this.writeObjSet((Set)value);
                break;
            }
            case 12: {
                byte[] bytes = (byte[])value;
                this.output.writeInt(bytes.length);
                this.output.write(bytes);
                break;
            }
            case 8: {
                this.writeYangInstanceIdentifierInternal((YangInstanceIdentifier)value);
                break;
            }
            case 15: {
                break;
            }
            case 14: {
                byte[] valueBytes = value.toString().getBytes(StandardCharsets.UTF_8);
                this.output.writeInt(valueBytes.length);
                this.output.write(valueBytes);
                break;
            }
            default: {
                this.output.writeUTF(value.toString());
            }
        }
    }
}

