/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.opendaylight.yangtools.yang.common.QName;

public final class QNameFactory {
    private static final int MAX_QNAME_CACHE_SIZE = 10000;
    private static final LoadingCache<String, QName> CACHE = CacheBuilder.newBuilder().maximumSize(10000L).softValues().build((CacheLoader)new CacheLoader<String, QName>(){

        public QName load(String key) {
            return QName.create((String)key);
        }
    });

    private QNameFactory() {
    }

    public static QName create(String name) {
        return (QName)CACHE.getUnchecked((Object)name);
    }
}

