/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.ControlMessage;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.dispatch.Envelope;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.UnboundedControlAwareMailbox;
import com.typesafe.config.Config;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.opendaylight.controller.cluster.common.actor.MeteredBoundedMailbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class UnboundedDequeBasedControlAwareMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue> {
    private static final Logger LOG = LoggerFactory.getLogger(UnboundedDequeBasedControlAwareMailbox.class);
    private static final String NORMAL_QUEUE_SIZE = "normal-q-size";
    private static final String CONTROL_QUEUE_SIZE = "control-q-size";
    private static final String TOTAL_QUEUE_SIZE = "total-q-size";

    public UnboundedDequeBasedControlAwareMailbox(ActorSystem.Settings settings, Config config) {
    }

    public MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        LOG.debug("Creating MessageQueue for {}", owner);
        MessageQueue queue = new MessageQueue();
        MeteredBoundedMailbox.registerMetric(owner, NORMAL_QUEUE_SIZE, () -> queue.queue().size());
        MeteredBoundedMailbox.registerMetric(owner, CONTROL_QUEUE_SIZE, () -> queue.controlQueue().size());
        MeteredBoundedMailbox.registerMetric(owner, TOTAL_QUEUE_SIZE, () -> ((MessageQueue)queue).numberOfMessages());
        return queue;
    }

    static class MessageQueue
    extends UnboundedControlAwareMailbox.MessageQueue
    implements DequeBasedMessageQueueSemantics {
        private static final long serialVersionUID = 1L;
        private final Deque<Envelope> controlQueue = new ConcurrentLinkedDeque<Envelope>();
        private final Deque<Envelope> queue = new ConcurrentLinkedDeque<Envelope>();

        MessageQueue() {
        }

        public Queue<Envelope> controlQueue() {
            return this.controlQueue;
        }

        public Queue<Envelope> queue() {
            return this.queue;
        }

        public void enqueueFirst(ActorRef actor, Envelope envelope) {
            Object message = envelope.message();
            LOG.trace("enqueueFirst: actor {}, message type: {}", (Object)actor, message.getClass());
            if (message instanceof ControlMessage) {
                LOG.trace("Adding {} to the ControlMessage queue", message.getClass());
                this.controlQueue.addFirst(envelope);
            } else {
                LOG.trace("Adding {} to the normal queue", message.getClass());
                this.queue.addFirst(envelope);
            }
        }
    }
}

