/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.authprovider;

import org.opendaylight.aaa.api.AuthenticationException;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.Credentials;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.netconf.auth.AuthProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialServiceAuthProvider
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialServiceAuthProvider.class);
    private final CredentialAuth<PasswordCredentials> credService;

    public CredentialServiceAuthProvider(CredentialAuth<PasswordCredentials> credService) {
        this.credService = credService;
    }

    public boolean authenticated(String username, String password) {
        Claim claim;
        try {
            claim = this.credService.authenticate((Credentials)new PasswordCredentialsWrapper(username, password));
        }
        catch (AuthenticationException e) {
            LOG.debug("Authentication failed for user '{}'", (Object)username, (Object)e);
            return false;
        }
        LOG.debug("Authentication result for user '{}' : {}", (Object)username, (Object)claim.domain());
        return true;
    }

    private static final class PasswordCredentialsWrapper
    implements PasswordCredentials {
        private final String username;
        private final String password;

        PasswordCredentialsWrapper(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public String domain() {
            return null;
        }
    }
}

