/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadFactoryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadFactoryProvider.class);
    private static final Thread.UncaughtExceptionHandler ERROR_HANDLER = (thread, cause) -> LOG.error("Uncaught error in thread {}", (Object)thread, (Object)cause);

    private ThreadFactoryProvider() {
    }

    public static ThreadFactory create(String prefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("jsonrpc-" + prefix + "-eventloop-%d").setUncaughtExceptionHandler(ERROR_HANDLER).build();
    }
}

