/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.concurrent.TimeUnit;
import org.opendaylight.jsonrpc.bus.spi.DefaultEventLoopConfiguration;
import org.opendaylight.jsonrpc.bus.spi.EventLoopConfiguration;

public final class EventLoopGroupProvider {
    private static final EventLoopGroup SHARED_GROUP = new NioEventLoopGroup(SystemPropertyUtil.getInt((String)"jsonrpc.eventloop.size", (int)12));
    private static final EventExecutorGroup HANDLER_GROUP = new DefaultEventExecutorGroup(SystemPropertyUtil.getInt((String)"jsonrpc.eventloop.size", (int)12));
    private static final EventLoopConfiguration CONFIG = new DefaultEventLoopConfiguration(SHARED_GROUP, SHARED_GROUP, HANDLER_GROUP);

    private EventLoopGroupProvider() {
    }

    public static EventLoopGroup getSharedGroup() {
        return SHARED_GROUP;
    }

    public static EventExecutorGroup getHandlerGroup() {
        return HANDLER_GROUP;
    }

    public static EventLoopConfiguration config() {
        return CONFIG;
    }

    public static void shutdown() {
        long awaitTermination = SystemPropertyUtil.getLong((String)"jsonrpc.eventloop.await.termination", (long)500L);
        SHARED_GROUP.shutdownGracefully(awaitTermination, awaitTermination, TimeUnit.MILLISECONDS);
        HANDLER_GROUP.shutdownGracefully(awaitTermination, awaitTermination, TimeUnit.MILLISECONDS);
        while (!SHARED_GROUP.isShutdown() || !HANDLER_GROUP.isShutdown()) {
            Thread.yield();
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return;
    }
}

