/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CombinedFuture<T>
extends DefaultPromise<T> {
    private Future<?> connectionFuture;
    private Promise<T> resultFuture;

    public CombinedFuture(Future<?> connectionFuture, Promise<T> resultFuture) {
        this.connectionFuture = Objects.requireNonNull(connectionFuture);
        this.resultFuture = Objects.requireNonNull(resultFuture);
    }

    public T get() throws InterruptedException, ExecutionException {
        this.connectionFuture.get();
        return (T)this.resultFuture.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.nanoTime();
        this.connectionFuture.get(timeout, unit);
        long diff = System.nanoTime() - start;
        return (T)this.resultFuture.get(unit.toNanos(timeout) - diff, TimeUnit.NANOSECONDS);
    }

    public Promise<T> addListener(GenericFutureListener<? extends Future<? super T>> listener) {
        return this.resultFuture.addListener(listener);
    }
}

