/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import com.google.common.net.InetAddresses;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.opendaylight.jsonrpc.bus.api.BusSession;
import org.opendaylight.jsonrpc.bus.api.SessionType;

public abstract class AbstractSession
implements AutoCloseable,
BusSession {
    protected volatile ChannelFuture channelFuture;
    protected final InetSocketAddress address;
    protected final URI uri;
    protected final SessionType sessionType;

    public AbstractSession(String uriStr, int defaultPort, SessionType sessionType) {
        this.uri = AbstractSession.getUriSafe(uriStr);
        this.address = AbstractSession.addressFromUri(this.uri, defaultPort);
        this.sessionType = Objects.requireNonNull(sessionType);
    }

    @Override
    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().syncUninterruptibly();
        }
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    protected static InetSocketAddress addressFromUri(URI uri, int defaultPort) {
        int port = uri.getPort() == -1 ? defaultPort : uri.getPort();
        return uri.getHost() == null ? new InetSocketAddress(InetAddresses.fromInteger((int)0), port) : new InetSocketAddress(uri.getHost(), port);
    }

    protected static URI getUriSafe(String uriStr) {
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid URI : '%s'", uriStr), e);
        }
    }

    public String toString() {
        return "AbstractSession [" + this.sessionType + "@" + this.uri + "@" + this.hashCode() + "]";
    }
}

