/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.jsonrpc.bus.api.ClientSession;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.AbstractSession;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.spi.ConnectionState;
import org.opendaylight.jsonrpc.bus.spi.ReconnectStrategies;
import org.opendaylight.jsonrpc.bus.spi.ReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReconnectingClient
extends AbstractSession
implements ClientSession {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReconnectingClient.class);
    private final Bootstrap clientBootstrap;
    private ScheduledFuture<?> reconnectFuture;
    protected volatile ConnectionState state = ConnectionState.INITIAL;
    private final ChannelFutureListener connectListener = new ConnectListener();
    private final ChannelFutureListener closeListener = new CloseListener();
    protected final AbstractChannelInitializer channelInitializer;
    private ReconnectStrategy reconnectStrategy;
    private final AtomicReference<Boolean> isFirstConnectionAttempt = new AtomicReference<Boolean>(true);
    private static final Set<ConnectionState> RECONNECT_STATES = ImmutableSet.builder().add((Object)ConnectionState.DONE).build();

    public AbstractReconnectingClient(String uri, int defaultPort, Bootstrap clientBootstrap, AbstractChannelInitializer channelInitializer, SessionType sessionType) {
        super(uri, defaultPort, sessionType);
        this.reconnectStrategy = ReconnectStrategies.fixedStartegy(1000L);
        this.channelInitializer = Objects.requireNonNull(channelInitializer);
        this.clientBootstrap = Objects.requireNonNull(clientBootstrap);
    }

    private void scheduleReconnect() {
        if (ConnectionState.DONE != this.state) {
            this.changeConnectionState(ConnectionState.INITIAL);
            this.reconnectFuture = this.clientBootstrap.config().group().schedule(this::connectInternal, this.reconnectStrategy.timeout(), TimeUnit.MILLISECONDS);
        }
    }

    protected void connectInternal() {
        if (this.state == ConnectionState.CONNECTED || this.state == ConnectionState.CONNECTING) {
            return;
        }
        if (this.state == ConnectionState.DONE) {
            throw new IllegalStateException("Client closed already : " + this.address);
        }
        LOG.debug("(Re)connecting to {} ", (Object)this.address);
        this.changeConnectionState(ConnectionState.CONNECTING);
        ((Bootstrap)this.clientBootstrap.handler((ChannelHandler)this.channelInitializer)).connect((SocketAddress)this.address).addListener((GenericFutureListener)this.connectListener);
    }

    private void changeConnectionState(ConnectionState newState) {
        if (this.state != newState) {
            LOG.debug("Changing connection state from {} to {} [{}]@{}", new Object[]{this.state, newState, this.channelFuture != null ? this.channelFuture.channel() : "N/A", this.hashCode()});
            this.state = newState;
        }
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    protected Future<Void> closeChannel() {
        this.changeConnectionState(ConnectionState.DONE);
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
        if (this.channelFuture != null) {
            return this.channelFuture.channel().close();
        }
        return Futures.immediateFuture(null);
    }

    public boolean isReady() {
        return this.state == ConnectionState.CONNECTED && this.handshakeFinished();
    }

    protected boolean handshakeFinished() {
        return (Boolean)this.channelFuture.channel().attr(CommonConstants.ATTR_HANDSHAKE_DONE).get();
    }

    protected void blockUntilConnected() {
        while (true) {
            if (ConnectionState.DONE == this.state) {
                throw new IllegalStateException("Client connection is done");
            }
            if (this.isReady()) {
                return;
            }
            this.block();
        }
    }

    @Override
    public void close() {
        this.closeChannel();
        super.close();
    }

    private void block() {
        LOG.trace("Waiting for connection to be established and negotiated...");
        Thread.yield();
        Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void awaitConnection() {
        this.blockUntilConnected();
    }

    @Override
    public String toString() {
        return "AbstractReconnectingClient [state=" + (Object)((Object)this.state) + ", uri=" + this.uri + ", sessionType=" + this.sessionType + ", hashCode=" + this.hashCode() + "]";
    }

    private class ConnectListener
    implements ChannelFutureListener {
        private ConnectListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                AbstractReconnectingClient.this.channelFuture = future;
                AbstractReconnectingClient.this.changeConnectionState(ConnectionState.CONNECTED);
                AbstractReconnectingClient.this.reconnectStrategy.reset();
                future.channel().closeFuture().addListener((GenericFutureListener)AbstractReconnectingClient.this.closeListener);
            } else {
                if (AbstractReconnectingClient.this.isFirstConnectionAttempt.getAndSet(false).booleanValue()) {
                    LOG.warn("Connection attempt to '{}' failed", (Object)AbstractReconnectingClient.this.address, (Object)future.cause());
                } else {
                    LOG.trace("Connection attempt to '{}' failed", (Object)AbstractReconnectingClient.this.address, (Object)future.cause());
                }
                AbstractReconnectingClient.this.scheduleReconnect();
            }
        }
    }

    private class CloseListener
    implements ChannelFutureListener {
        private CloseListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!RECONNECT_STATES.contains((Object)AbstractReconnectingClient.this.state)) {
                LOG.debug("Scheduling reconnect because state is {}@{}", (Object)AbstractReconnectingClient.this.state, (Object)this.hashCode());
                AbstractReconnectingClient.this.changeConnectionState(ConnectionState.INITIAL);
                AbstractReconnectingClient.this.scheduleReconnect();
            }
        }
    }
}

