/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.encrypt.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MdsalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalUtils.class);

    private MdsalUtils() {
    }

    public static InstanceIdentifier<AaaEncryptServiceConfig> getEncryptionSrvConfigIid() {
        return InstanceIdentifier.builder(AaaEncryptServiceConfig.class).build();
    }

    public static <T extends DataObject> void initalizeDatastore(LogicalDatastoreType type, DataBroker dataBroker, InstanceIdentifier<T> iid, T object) {
        WriteTransaction transaction = dataBroker.newWriteOnlyTransaction();
        transaction.put(type, iid, object);
        Futures.addCallback((ListenableFuture)transaction.commit(), (FutureCallback)new FutureCallback<CommitInfo>(){

            public void onFailure(Throwable throwable) {
                LOG.error("initDatastore: transaction failed");
            }

            public void onSuccess(CommitInfo result) {
                LOG.debug("initDatastore: transaction succeeded");
            }
        }, (Executor)MoreExecutors.directExecutor());
        LOG.info("initDatastore: data populated: {}, {}, {}", new Object[]{type, iid, object});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <D extends DataObject> D read(DataBroker dataBroker, LogicalDatastoreType store, InstanceIdentifier<D> path) {
        try (ReadTransaction transaction = dataBroker.newReadOnlyTransaction();){
            Optional optionalDataObject = (Optional)transaction.read(store, path).get();
            if (!optionalDataObject.isPresent()) return null;
            DataObject dataObject = (DataObject)optionalDataObject.get();
            return (D)dataObject;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to read {} ", path, (Object)e);
        }
        return null;
    }
}

