/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PasswordServiceConfigBuilder
implements Builder<PasswordServiceConfig> {
    private String _algorithm;
    private Integer _iterations;
    private String _privateSalt;
    Map<Class<? extends Augmentation<PasswordServiceConfig>>, Augmentation<PasswordServiceConfig>> augmentation = Collections.emptyMap();

    public PasswordServiceConfigBuilder() {
    }

    public PasswordServiceConfigBuilder(PasswordServiceConfig base) {
        Map aug;
        this._algorithm = base.getAlgorithm();
        this._iterations = base.getIterations();
        this._privateSalt = base.getPrivateSalt();
        if (base instanceof PasswordServiceConfigImpl) {
            PasswordServiceConfigImpl impl = (PasswordServiceConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PasswordServiceConfig>>, Augmentation<PasswordServiceConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PasswordServiceConfig>>, Augmentation<PasswordServiceConfig>>(aug);
        }
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public Integer getIterations() {
        return this._iterations;
    }

    public String getPrivateSalt() {
        return this._privateSalt;
    }

    public <E$$ extends Augmentation<PasswordServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PasswordServiceConfigBuilder setAlgorithm(String value) {
        this._algorithm = value;
        return this;
    }

    public PasswordServiceConfigBuilder setIterations(Integer value) {
        this._iterations = value;
        return this;
    }

    public PasswordServiceConfigBuilder setPrivateSalt(String value) {
        this._privateSalt = value;
        return this;
    }

    public PasswordServiceConfigBuilder addAugmentation(Class<? extends Augmentation<PasswordServiceConfig>> augmentationType, Augmentation<PasswordServiceConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PasswordServiceConfig>>, Augmentation<PasswordServiceConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PasswordServiceConfigBuilder removeAugmentation(Class<? extends Augmentation<PasswordServiceConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PasswordServiceConfig build() {
        return new PasswordServiceConfigImpl(this);
    }

    private static final class PasswordServiceConfigImpl
    implements PasswordServiceConfig {
        private final String _algorithm;
        private final Integer _iterations;
        private final String _privateSalt;
        private Map<Class<? extends Augmentation<PasswordServiceConfig>>, Augmentation<PasswordServiceConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PasswordServiceConfigImpl(PasswordServiceConfigBuilder base) {
            this._algorithm = base.getAlgorithm();
            this._iterations = base.getIterations();
            this._privateSalt = base.getPrivateSalt();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PasswordServiceConfig> getImplementedInterface() {
            return PasswordServiceConfig.class;
        }

        @Override
        public String getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public Integer getIterations() {
            return this._iterations;
        }

        @Override
        public String getPrivateSalt() {
            return this._privateSalt;
        }

        @Override
        public <E$$ extends Augmentation<PasswordServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._algorithm);
            result = 31 * result + Objects.hashCode(this._iterations);
            result = 31 * result + Objects.hashCode(this._privateSalt);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PasswordServiceConfig.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PasswordServiceConfig other = (PasswordServiceConfig)obj;
            if (!Objects.equals(this._algorithm, other.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this._iterations, other.getIterations())) {
                return false;
            }
            if (!Objects.equals(this._privateSalt, other.getPrivateSalt())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PasswordServiceConfigImpl otherImpl = (PasswordServiceConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PasswordServiceConfig>>, Augmentation<PasswordServiceConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PasswordServiceConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_algorithm", (Object)this._algorithm);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_iterations", (Object)this._iterations);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_privateSalt", (Object)this._privateSalt);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

