/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.web.env;

import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.Factory;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.aaa.shiro.web.env.ThreadLocals;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.configuration.Main;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.configuration.Urls;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AAAIniWebEnvironment
extends IniWebEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(AAAIniWebEnvironment.class);
    private static final String MAIN_SECTION_HEADER = "main";
    private static final String URLS_SECTION_HEADER = "urls";
    private final ShiroConfiguration shiroConfiguration;
    private final DataBroker dataBroker;
    private final ICertificateManager certificateManager;
    private final AuthenticationService authenticationService;
    private final TokenAuthenticators tokenAuthenticators;
    private final TokenStore tokenStore;
    private final PasswordHashService passwordHashService;

    AAAIniWebEnvironment(ShiroConfiguration shiroConfiguration, DataBroker dataBroker, ICertificateManager certificateManager, AuthenticationService authenticationService, TokenAuthenticators tokenAuthenticators, TokenStore tokenStore, PasswordHashService passwordHashService) {
        this.shiroConfiguration = shiroConfiguration;
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.authenticationService = authenticationService;
        this.tokenAuthenticators = tokenAuthenticators;
        this.tokenStore = tokenStore;
        this.passwordHashService = passwordHashService;
        LOG.debug("AAAIniWebEnvironment created");
    }

    static Ini createIniFromClusteredAppConfig(ShiroConfiguration shiroConfiguration) {
        Ini ini = new Ini();
        Ini.Section mainSection = ini.addSection(MAIN_SECTION_HEADER);
        List mains = shiroConfiguration.getMain();
        for (Main main : mains) {
            mainSection.put(main.getPairKey(), main.getPairValue());
        }
        Ini.Section urlsSection = ini.addSection(URLS_SECTION_HEADER);
        List urls = shiroConfiguration.getUrls();
        for (Urls url : urls) {
            urlsSection.put(url.getPairKey(), url.getPairValue());
        }
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(ini);
        SecurityManager securityManager = (SecurityManager)ClassLoaderUtils.getWithClassLoader((ClassLoader)AAAIniWebEnvironment.class.getClassLoader(), () -> ((Factory)factory).getInstance());
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        return ini;
    }

    public void init() {
        ThreadLocals.DATABROKER_TL.set(this.dataBroker);
        ThreadLocals.CERT_MANAGER_TL.set(this.certificateManager);
        ThreadLocals.AUTH_SETVICE_TL.set(this.authenticationService);
        ThreadLocals.TOKEN_AUTHENICATORS_TL.set(this.tokenAuthenticators);
        ThreadLocals.TOKEN_STORE_TL.set(this.tokenStore);
        ThreadLocals.PASSWORD_HASH_SERVICE_TL.set(this.passwordHashService);
        try {
            Ini ini = AAAIniWebEnvironment.createIniFromClusteredAppConfig(this.shiroConfiguration);
            this.setIni(ini);
            ClassLoaderUtils.getWithClassLoader((ClassLoader)AAAIniWebEnvironment.class.getClassLoader(), () -> {
                super.init();
                return null;
            });
        }
        finally {
            ThreadLocals.DATABROKER_TL.remove();
            ThreadLocals.CERT_MANAGER_TL.remove();
            ThreadLocals.AUTH_SETVICE_TL.remove();
            ThreadLocals.TOKEN_AUTHENICATORS_TL.remove();
            ThreadLocals.TOKEN_STORE_TL.remove();
            ThreadLocals.PASSWORD_HASH_SERVICE_TL.remove();
        }
    }
}

