/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.tokenauthrealm.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.AuthenticationException;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.Credentials;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.AuthenticationBuilder;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.PasswordCredentialBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuth
implements TokenAuth {
    public static final String AUTH_HEADER = "Authorization";
    public static final String AUTH_SEP = ":";
    public static final String BASIC_PREFIX = "Basic ";
    public static final String DEFAULT_DOMAIN = "sdn";
    private static final int NUM_HEADER_CREDS = 2;
    private static final int NUM_TOKEN_CREDS = 3;
    private static final Logger LOG = LoggerFactory.getLogger(HttpBasicAuth.class);
    private final CredentialAuth<PasswordCredentials> credentialAuth;

    public HttpBasicAuth(CredentialAuth<PasswordCredentials> credentialAuth) {
        this.credentialAuth = credentialAuth;
    }

    private static boolean checkAuthHeaderFormat(String authHeader) {
        return authHeader != null && authHeader.startsWith(BASIC_PREFIX);
    }

    private static String extractAuthHeader(Map<String, List<String>> headers) {
        return headers.get(AUTH_HEADER).get(0);
    }

    private static String[] extractCredentialArray(String authHeader) {
        return new String(Base64.getDecoder().decode(authHeader.substring(BASIC_PREFIX.length())), StandardCharsets.UTF_8).split(AUTH_SEP);
    }

    private static boolean verifyCredentialArray(String[] creds) {
        return creds != null && creds.length == 2;
    }

    private static String[] addDomainToCredentialArray(String[] creds) {
        String[] newCredentialArray = new String[3];
        System.arraycopy(creds, 0, newCredentialArray, 0, creds.length);
        newCredentialArray[2] = DEFAULT_DOMAIN;
        return newCredentialArray;
    }

    private static Authentication generateAuthentication(CredentialAuth<PasswordCredentials> credentialAuth, String[] creds) throws ArrayIndexOutOfBoundsException {
        PasswordCredentials pc = new PasswordCredentialBuilder().setUserName(creds[0]).setPassword(creds[1]).setDomain(creds[2]).build();
        Claim claim = credentialAuth.authenticate((Credentials)pc);
        return new AuthenticationBuilder(claim).build();
    }

    public Authentication validate(Map<String, List<String>> headers) throws AuthenticationException {
        String authHeader;
        if (headers.containsKey(AUTH_HEADER) && HttpBasicAuth.checkAuthHeaderFormat(authHeader = HttpBasicAuth.extractAuthHeader(headers))) {
            String[] creds = HttpBasicAuth.extractCredentialArray(authHeader);
            if (HttpBasicAuth.verifyCredentialArray(creds)) {
                creds = HttpBasicAuth.addDomainToCredentialArray(creds);
            }
            try {
                return HttpBasicAuth.generateAuthentication(this.credentialAuth, creds);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String message = "Login Attempt in Bad Format. Please provide user:password in Base64 format.";
                LOG.info("Login Attempt in Bad Format. Please provide user:password in Base64 format.");
                throw new AuthenticationException("Login Attempt in Bad Format. Please provide user:password in Base64 format.", (Throwable)e);
            }
        }
        return null;
    }
}

