/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.tokenauthrealm.auth;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.aaa.api.Claim;

public class ClaimBuilder {
    private String userId = "";
    private String user = "";
    private final Set<String> roles = new LinkedHashSet<String>();
    private String clientId = "";
    private String domain = "";

    public ClaimBuilder() {
    }

    public ClaimBuilder(Claim claim) {
        this.clientId = claim.clientId();
        this.userId = claim.userId();
        this.user = claim.user();
        this.domain = claim.domain();
        this.roles.addAll(claim.roles());
    }

    public ClaimBuilder setClientId(String clientId) {
        this.clientId = Strings.nullToEmpty(clientId).trim();
        return this;
    }

    public ClaimBuilder setUserId(String userId) {
        this.userId = Strings.nullToEmpty(userId).trim();
        return this;
    }

    public ClaimBuilder setUser(String userName) {
        this.user = Strings.nullToEmpty(userName).trim();
        return this;
    }

    public ClaimBuilder setDomain(String domain) {
        this.domain = Strings.nullToEmpty(domain).trim();
        return this;
    }

    public ClaimBuilder addRoles(Set<String> theRoles) {
        for (String role : theRoles) {
            this.addRole(role);
        }
        return this;
    }

    public ClaimBuilder addRole(String role) {
        this.roles.add(Strings.nullToEmpty(role).trim());
        return this;
    }

    public Claim build() {
        return new ImmutableClaim(this);
    }

    protected static class ImmutableClaim
    implements Claim,
    Serializable {
        private static final long serialVersionUID = -8115027645190209129L;
        private int hashCode = 0;
        protected String clientId;
        protected String userId;
        protected String user;
        protected String domain;
        protected ImmutableSet<String> roles;

        protected ImmutableClaim(ClaimBuilder base) {
            this.clientId = base.clientId;
            this.userId = base.userId;
            this.user = base.user;
            this.domain = base.domain;
            this.roles = ((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)base.roles)).build();
            if (this.userId.isEmpty() || this.user.isEmpty() || this.roles.isEmpty() || this.roles.contains("")) {
                throw new IllegalStateException("The Claim is missing one or more of the required fields.");
            }
        }

        public String clientId() {
            return this.clientId;
        }

        public String userId() {
            return this.userId;
        }

        public String user() {
            return this.user;
        }

        public String domain() {
            return this.domain;
        }

        public Set<String> roles() {
            return this.roles;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Claim)) {
                return false;
            }
            Claim claim = (Claim)object;
            return Objects.equals(this.roles, claim.roles()) && Objects.equals(this.domain, claim.domain()) && Objects.equals(this.userId, claim.userId()) && Objects.equals(this.user, claim.user()) && Objects.equals(this.clientId, claim.clientId());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Objects.hash(this.clientId, this.userId, this.user, this.domain, this.roles);
            }
            return this.hashCode;
        }

        public String toString() {
            return "clientId:" + this.clientId + ",userId:" + this.userId + ",userName:" + this.user + ",domain:" + this.domain + ",roles:" + this.roles;
        }
    }
}

