/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.IDMError;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.Roles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/roles")
public class RoleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RoleHandler.class);
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public RoleHandler(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = iidMStore;
        this.claimCache = claimCache;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRoles() {
        LOG.info("get /roles");
        Roles roles = null;
        try {
            roles = this.iidMStore.getRoles();
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error getting the roles", e);
            return new IDMError(500, "internal error getting roles", e.getMessage()).response();
        }
        return Response.ok((Object)roles).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getRole(@PathParam(value="id") String id) {
        LOG.info("get /roles/{}", (Object)id);
        Role role = null;
        try {
            role = this.iidMStore.readRole(id);
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error getting the role", e);
            return new IDMError(500, "internal error getting roles", e.getMessage()).response();
        }
        if (role == null) {
            return new IDMError(404, "role not found id:" + id, "").response();
        }
        return Response.ok((Object)role).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRole(@Context UriInfo info, Role role) {
        LOG.info("Post /roles");
        try {
            if (role.getRoleid() != null) {
                String errorMessage = "do not specify roleId, it will be assigned automatically for you";
                LOG.debug("do not specify roleId, it will be assigned automatically for you");
                IDMError idmError = new IDMError();
                idmError.setMessage("do not specify roleId, it will be assigned automatically for you");
                return Response.status((int)400).entity((Object)idmError).build();
            }
            if (role.getName() == null) {
                return new IDMError(404, "name must be defined on role create", "").response();
            }
            if (role.getName().length() > 256) {
                return new IDMError(400, "role name max length is :256", "").response();
            }
            if (role.getDomainid() == null) {
                return new IDMError(404, "The role's domain must be defined on role when creating a role.", "").response();
            }
            if (role.getDomainid().length() > 256) {
                return new IDMError(400, "role domain max length is :256", "").response();
            }
            if (role.getDescription() == null) {
                role.setDescription("");
            } else if (role.getDescription().length() > 256) {
                return new IDMError(400, "role description max length is :256", "").response();
            }
            role = this.iidMStore.writeRole(role);
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error creating role", e);
            return new IDMError(500, "internal error creating role", e.getMessage()).response();
        }
        return Response.status((int)201).entity((Object)role).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putRole(@Context UriInfo info, Role role, @PathParam(value="id") String id) {
        LOG.info("put /roles/{}", (Object)id);
        try {
            role.setRoleid(id);
            if (role.getName() != null && role.getName().length() > 256) {
                return new IDMError(400, "role name max length is :256", "").response();
            }
            if (role.getDescription() != null && role.getDescription().length() > 256) {
                return new IDMError(400, "role description max length is :256", "").response();
            }
            if ((role = this.iidMStore.updateRole(role)) == null) {
                return new IDMError(404, "role id not found :" + id, "").response();
            }
            this.claimCache.clear();
            return Response.status((int)200).entity((Object)role).build();
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error putting role", e);
            return new IDMError(500, "internal error putting role", e.getMessage()).response();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteRole(@Context UriInfo info, @PathParam(value="id") String id) {
        LOG.info("Delete /roles/{}", (Object)id);
        try {
            Role role = this.iidMStore.deleteRole(id);
            if (role == null) {
                return new IDMError(404, "role id not found :" + id, "").response();
            }
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error deleting role", e);
            return new IDMError(500, "internal error deleting role", e.getMessage()).response();
        }
        this.claimCache.clear();
        return Response.status((int)204).build();
    }
}

