/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.Claim;
import org.opendaylight.aaa.api.model.Domain;
import org.opendaylight.aaa.api.model.Domains;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.Grants;
import org.opendaylight.aaa.api.model.IDMError;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.Roles;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.UserPwd;
import org.opendaylight.aaa.api.model.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/domains")
public class DomainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DomainHandler.class);
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public DomainHandler(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = Objects.requireNonNull(iidMStore);
        this.claimCache = Objects.requireNonNull(claimCache);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDomains() {
        LOG.info("Get /domains");
        Domains domains = null;
        try {
            domains = this.iidMStore.getDomains();
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domains");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        return Response.ok((Object)domains).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getDomain(@PathParam(value="id") String domainId) {
        LOG.info("Get /domains/{}", (Object)domainId);
        Domain domain = null;
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! domain id :" + domainId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        return Response.ok((Object)domain).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createDomain(@Context UriInfo info, Domain domain) {
        LOG.info("Post /domains");
        try {
            if (domain.getDomainid() != null) {
                String errorMessage = "do not specify domainId, it will be assigned automatically for you";
                LOG.debug("do not specify domainId, it will be assigned automatically for you");
                IDMError idmError = new IDMError();
                idmError.setMessage("do not specify domainId, it will be assigned automatically for you");
                return Response.status((int)400).entity((Object)idmError).build();
            }
            if (domain.isEnabled() == null) {
                domain.setEnabled(false);
            }
            if (domain.getName() == null) {
                domain.setName("");
            }
            if (domain.getDescription() == null) {
                domain.setDescription("");
            }
            domain = this.iidMStore.writeDomain(domain);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        return Response.status((int)201).entity((Object)domain).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putDomain(@Context UriInfo info, Domain domain, @PathParam(value="id") String domainId) {
        LOG.info("Put /domains/{}", (Object)domainId);
        try {
            domain.setDomainid(domainId);
            domain = this.iidMStore.updateDomain(domain);
            if (domain == null) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("Not found! Domain id:" + domainId);
                return Response.status((int)404).entity((Object)idmerror).build();
            }
            this.claimCache.clear();
            return Response.status((int)200).entity((Object)domain).build();
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error putting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteDomain(@Context UriInfo info, @PathParam(value="id") String domainId) {
        LOG.info("Delete /domains/{}", (Object)domainId);
        try {
            Domain domain = this.iidMStore.deleteDomain(domainId);
            if (domain == null) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("Not found! Domain id:" + domainId);
                return Response.status((int)404).entity((Object)idmerror).build();
            }
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error deleting Domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.status((int)204).build();
    }

    @POST
    @Path(value="/{did}/users/{uid}/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createGrant(@Context UriInfo info, @PathParam(value="did") String domainId, @PathParam(value="uid") String userId, Grant grant) {
        Role role;
        String roleId;
        User user;
        LOG.info("Post /domains/{}/users/{}/roles", (Object)domainId, (Object)userId);
        if (grant.getGrantid() != null) {
            String errorMessage = "do not specify grantId, it will be assigned automatically for you";
            LOG.debug("do not specify grantId, it will be assigned automatically for you");
            IDMError idmError = new IDMError();
            idmError.setMessage("do not specify grantId, it will be assigned automatically for you");
            return Response.status((int)400).entity((Object)idmError).build();
        }
        Domain domain = null;
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! domain id :" + domainId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        grant.setDomainid(domainId);
        try {
            user = this.iidMStore.readUser(userId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (user == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! User id:" + userId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        grant.setUserid(userId);
        try {
            roleId = grant.getRoleid();
            LOG.info("roleid = {}", (Object)roleId);
        }
        catch (NumberFormatException nfe) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Invalid Role id:" + grant.getRoleid());
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            role = this.iidMStore.readRole(roleId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting role");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (role == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! role:" + grant.getRoleid());
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            Grant existingGrant = this.iidMStore.readGrant(domainId, userId, roleId);
            if (existingGrant != null) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("Grant already exists for did:" + domainId + " uid:" + userId + " rid:" + roleId);
                return Response.status((int)403).entity((Object)idmerror).build();
            }
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating grant");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        try {
            grant = this.iidMStore.writeGrant(grant);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException: ", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating grant");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.status((int)201).entity((Object)grant).build();
    }

    @POST
    @Path(value="/{did}/users/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validateUser(@Context UriInfo info, @PathParam(value="did") String domainId, UserPwd userpwd) {
        LOG.info("GET /domains/{}/users", (Object)domainId);
        Domain domain = null;
        Claim claim = new Claim();
        ArrayList<Role> roleList = new ArrayList<Role>();
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException se) {
            LOG.error("StoreException: ", se);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(se.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        String username = userpwd.getUsername();
        if (username == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("username not specfied in request body");
            return Response.status((int)400).entity((Object)idmerror).build();
        }
        String pwd = userpwd.getUserpwd();
        if (pwd == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("userpwd not specfied in request body");
            return Response.status((int)400).entity((Object)idmerror).build();
        }
        try {
            String reqPwd;
            Users users = this.iidMStore.getUsers(username, domainId);
            List<User> userList = users.getUsers();
            if (userList.size() == 0) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("did not find username: " + username);
                return Response.status((int)404).entity((Object)idmerror).build();
            }
            User user = userList.get(0);
            String userPwd = user.getPassword();
            if (!userPwd.equals(reqPwd = userpwd.getUserpwd())) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("password does not match for username: " + username);
                return Response.status((int)401).entity((Object)idmerror).build();
            }
            claim.setDomainid(domainId);
            claim.setUsername(username);
            claim.setUserid(user.getUserid());
            try {
                Grants grants = this.iidMStore.getGrants(domainId, user.getUserid());
                for (Grant grant : grants.getGrants()) {
                    Role role = this.iidMStore.readRole(grant.getRoleid());
                    roleList.add(role);
                }
            }
            catch (IDMStoreException e) {
                LOG.error("StoreException", e);
                IDMError idmerror = new IDMError();
                idmerror.setMessage("Internal error getting Roles");
                idmerror.setDetails(e.getMessage());
                return Response.status((int)500).entity((Object)idmerror).build();
            }
            claim.setRoles(roleList);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        return Response.ok((Object)claim).build();
    }

    @GET
    @Path(value="/{did}/users/{uid}/roles")
    @Produces(value={"application/json"})
    public Response getRoles(@Context UriInfo info, @PathParam(value="did") String domainId, @PathParam(value="uid") String userId) {
        User user;
        LOG.info("GET /domains/{}/users/{}/roles", (Object)domainId, (Object)userId);
        Domain domain = null;
        ArrayList<Role> roleList = new ArrayList<Role>();
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            user = this.iidMStore.readUser(userId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (user == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! User id:" + userId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            Grants grants = this.iidMStore.getGrants(domainId, userId);
            for (Grant grant : grants.getGrants()) {
                Role role = this.iidMStore.readRole(grant.getRoleid());
                roleList.add(role);
            }
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting Roles");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        Roles roles = new Roles();
        roles.setRoles(roleList);
        return Response.ok((Object)roles).build();
    }

    @DELETE
    @Path(value="/{did}/users/{uid}/roles/{rid}")
    public Response deleteGrant(@Context UriInfo info, @PathParam(value="did") String domainId, @PathParam(value="uid") String userId, @PathParam(value="rid") String roleId) {
        Role role;
        User user;
        Domain domain = null;
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("Error deleting Grant", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            user = this.iidMStore.readUser(userId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (user == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! User id:" + userId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            role = this.iidMStore.readRole(roleId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting Role");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        if (role == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Role id:" + roleId);
            return Response.status((int)404).entity((Object)idmerror).build();
        }
        try {
            Grant existingGrant = this.iidMStore.readGrant(domainId, userId, roleId);
            if (existingGrant == null) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("Grant does not exist for did:" + domainId + " uid:" + userId + " rid:" + roleId);
                return Response.status((int)404).entity((Object)idmerror).build();
            }
            this.iidMStore.deleteGrant(existingGrant.getGrantid());
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating grant");
            idmerror.setDetails(e.getMessage());
            return Response.status((int)500).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.status((int)204).build();
    }
}

