/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.filters;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.TokenType;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.shiro.moon.MoonPrincipal;
import org.opendaylight.aaa.shiro.oauth2.OAuthRequest;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.AuthenticationBuilder;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.ClaimBuilder;
import org.opendaylight.aaa.shiro.web.env.ThreadLocals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoonOAuthFilter
extends AuthenticatingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MoonOAuthFilter.class);
    private static final String UNAUTHORIZED = "unauthorized";
    private static final String UNAUTHORIZED_CREDENTIALS = "Unauthorized: Login/Password incorrect";
    static final String TOKEN_GRANT_ENDPOINT = "/token";
    static final String TOKEN_REVOKE_ENDPOINT = "/revoke";
    static final String TOKEN_VALIDATE_ENDPOINT = "/validate";
    private final TokenStore tokenStore = ThreadLocals.TOKEN_STORE_TL.get();

    protected UsernamePasswordToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        OAuthRequest oauthRequest;
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            oauthRequest = new OAuthRequest(httpRequest);
        }
        catch (ClassCastException e) {
            LOG.debug("createToken() failed since the request could not be cast appropriately", e);
            throw e;
        }
        return new UsernamePasswordToken(oauthRequest.getUsername(), oauthRequest.getPassword());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        SecurityUtils.getSubject();
        return this.executeLogin(request, response);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        MoonPrincipal principal;
        HttpServletResponse httpResponse;
        try {
            httpResponse = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            LOG.debug("onLoginSuccess() failed since the response could not be cast appropriately", e);
            throw e;
        }
        try {
            principal = (MoonPrincipal)subject.getPrincipals().getPrimaryPrincipal();
        }
        catch (ClassCastException e) {
            LOG.debug("onLoginSuccess() failed since the subject could not be cast appropriately", e);
            throw e;
        }
        Claim claim = principal.principalToClaim();
        this.oauthAccessTokenResponse(httpResponse, claim, "", principal.getToken());
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException authenticationException, ServletRequest request, ServletResponse response) {
        try {
            HttpServletResponse resp = (HttpServletResponse)response;
            this.error(resp, 400, UNAUTHORIZED_CREDENTIALS);
        }
        catch (ClassCastException cce) {
            LOG.warn("onLoginFailure() failed since the response could not be cast appropriately", cce);
        }
        return false;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletResponse resp;
        HttpServletRequest req;
        try {
            req = (HttpServletRequest)request;
        }
        catch (ClassCastException e) {
            LOG.debug("executeLogin() failed since the request could not be cast appropriately", e);
            throw e;
        }
        try {
            resp = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            LOG.debug("executeLogin() failed since the request could not be cast apprioately", e);
            throw e;
        }
        try {
            if (req.getServletPath().equals(TOKEN_GRANT_ENDPOINT)) {
                UsernamePasswordToken token = this.createToken(request, response);
                if (token == null) {
                    String msg = "A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
                    throw new IllegalStateException("A valid non-null AuthenticationToken must be created in order to execute a login attempt.");
                }
                try {
                    Subject subject = this.getSubject(request, response);
                    subject.login((AuthenticationToken)token);
                    return this.onLoginSuccess((AuthenticationToken)token, subject, request, response);
                }
                catch (AuthenticationException e) {
                    return this.onLoginFailure((AuthenticationToken)token, e, request, response);
                }
            }
        }
        catch (AuthenticationException e) {
            this.error(resp, 401, e.getMessage());
        }
        catch (OAuthProblemException oe) {
            this.error(resp, oe);
        }
        catch (RuntimeException e) {
            this.error(resp, e);
        }
        return false;
    }

    private void oauthAccessTokenResponse(HttpServletResponse resp, Claim claim, String clientId, String token) throws OAuthSystemException, IOException {
        if (claim == null) {
            throw new AuthenticationException(UNAUTHORIZED);
        }
        Authentication auth = new AuthenticationBuilder(new ClaimBuilder(claim).setClientId(clientId).build()).setExpiration(this.tokenExpiration()).build();
        this.tokenStore.put(token, auth);
        OAuthResponse r = OAuthASResponse.tokenResponse((int)201).setAccessToken(token).setTokenType(TokenType.BEARER.toString()).setExpiresIn(Long.toString(auth.expiration())).buildJSONMessage();
        this.write(resp, r);
    }

    private void write(HttpServletResponse resp, OAuthResponse response) throws IOException {
        resp.setStatus(response.getResponseStatus());
        PrintWriter pw = resp.getWriter();
        pw.print(response.getBody());
        pw.flush();
        pw.close();
    }

    private long tokenExpiration() {
        return this.tokenStore.tokenExpiration();
    }

    private void error(HttpServletResponse resp, int httpCode, String error) {
        try {
            OAuthResponse r = OAuthResponse.errorResponse((int)httpCode).setError(error).buildJSONMessage();
            this.write(resp, r);
        }
        catch (IOException | OAuthSystemException ex) {
            LOG.error("Failed to write the error ", ex);
        }
    }

    private void error(HttpServletResponse resp, OAuthProblemException oauthProblemException) {
        try {
            OAuthResponse r = OAuthResponse.errorResponse((int)400).error(oauthProblemException).buildJSONMessage();
            this.write(resp, r);
        }
        catch (IOException | OAuthSystemException ex) {
            LOG.error("Failed to write the error ", ex);
        }
    }

    private void error(HttpServletResponse resp, Exception exception) {
        try {
            OAuthResponse r = OAuthResponse.errorResponse((int)500).setError(exception.getClass().getName()).setErrorDescription(exception.getMessage()).buildJSONMessage();
            this.write(resp, r);
        }
        catch (IOException | OAuthSystemException ex) {
            LOG.error("Failed to write the error ", ex);
        }
    }
}

