/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.datastore.h2;

import java.io.File;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
@Value.Style(strictBuilder=true, builder="new", typeImmutable="*Impl", visibility=Value.Style.ImplementationVisibility.PRIVATE)
public abstract class IdmLightConfig {
    private static final Logger LOG = LoggerFactory.getLogger(IdmLightConfig.class);

    @Value.Default
    public String getDbName() {
        return "idmlight.db";
    }

    @Value.Default
    public String getDbDirectory() {
        return "./data";
    }

    @Value.Default
    public String getDbDriver() {
        return "org.h2.Driver";
    }

    public abstract String getDbUser();

    public abstract String getDbPwd();

    @Value.Default
    public int getDbValidTimeOut() {
        return 3;
    }

    @Value.Default
    public String getDbConnectionStringPrefix() {
        return "jdbc:h2:";
    }

    @Value.Default
    public String getDbConnectionString() {
        return this.getDbConnectionStringPrefix() + this.getDbDirectory() + File.separatorChar + this.getDbName();
    }

    public void log() {
        LOG.info("DB Path                 : {}", (Object)this.getDbConnectionString());
        LOG.info("DB Driver               : {}", (Object)this.getDbDriver());
        LOG.info("DB Valid Time Out       : {}", (Object)this.getDbValidTimeOut());
    }
}

