/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.jar;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.StoreBuilder;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.datastore.h2.H2Store;
import org.opendaylight.aaa.datastore.h2.IdmLightConfig;
import org.opendaylight.aaa.datastore.h2.IdmLightConfigBuilder;
import org.opendaylight.aaa.datastore.h2.IdmLightSimpleConnectionProvider;
import org.opendaylight.aaa.impl.password.service.DefaultPasswordHashService;

public class StandaloneCommandLineInterface {
    private final IIDMStore identityStore;
    private final StoreBuilder storeBuilder;
    private static final String DOMAIN = "sdn";
    private final PasswordHashService passwordService;

    public StandaloneCommandLineInterface(File directoryWithDatabaseFile) throws IOException, IDMStoreException {
        IdmLightConfigBuilder configBuider = new IdmLightConfigBuilder();
        configBuider.dbDirectory(directoryWithDatabaseFile.getCanonicalPath()).dbUser("foo").dbPwd("bar");
        IdmLightConfig config = configBuider.build();
        this.passwordService = new DefaultPasswordHashService();
        H2Store h2Store = new H2Store(new IdmLightSimpleConnectionProvider(config), this.passwordService);
        this.identityStore = h2Store;
        this.storeBuilder = new StoreBuilder(h2Store);
        this.storeBuilder.initDomainAndRolesWithoutUsers(DOMAIN);
    }

    public List<String> getAllUserNames() throws IDMStoreException {
        List<User> users = this.identityStore.getUsers().getUsers();
        return users.stream().map(User::getName).collect(Collectors.toList());
    }

    public boolean resetPassword(String userIdWithoutDomain, String newPassword) throws IDMStoreException {
        Optional<User> optUser = this.getSingleUser(userIdWithoutDomain);
        if (!optUser.isPresent()) {
            return false;
        }
        User user = optUser.get();
        user.setPassword(newPassword);
        this.identityStore.updateUser(user);
        return true;
    }

    public boolean checkUserPassword(String userIdWithoutDomain, String password) throws IDMStoreException {
        Optional<User> optUser = this.getSingleUser(userIdWithoutDomain);
        if (!optUser.isPresent()) {
            return false;
        }
        User user = optUser.get();
        return this.passwordService.passwordsMatch(password, user.getPassword(), user.getSalt());
    }

    private Optional<User> getSingleUser(String userIdWithoutDomain) throws IDMStoreException {
        Preconditions.checkNotNull(userIdWithoutDomain, "userIdWithoutDomain == null");
        List<User> users = this.identityStore.getUsers(userIdWithoutDomain, DOMAIN).getUsers();
        if (users.isEmpty()) {
            return Optional.empty();
        }
        if (users.size() > 1) {
            throw new IDMStoreException("More than 1 user found: " + userIdWithoutDomain);
        }
        return Optional.of(users.get(0));
    }

    public void createNewUser(String userName, String password, boolean isAdmin) throws IDMStoreException {
        Preconditions.checkNotNull(userName, "userName == null");
        this.storeBuilder.createUser(DOMAIN, userName, password, isAdmin);
    }

    public boolean deleteUser(String userIdWithoutDomain) throws IDMStoreException {
        Preconditions.checkNotNull(userIdWithoutDomain, "userIdWithoutDomain == null");
        return this.storeBuilder.deleteUser(DOMAIN, userIdWithoutDomain);
    }
}

