/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.jar;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.cli.jar.AbstractMain;
import org.opendaylight.aaa.cli.jar.StandaloneCommandLineInterface;

public class Main
extends AbstractMain {
    private StandaloneCommandLineInterface cli;

    public static void main(String[] args) throws Exception {
        System.exit(new Main().parseArguments(args));
    }

    @Override
    protected void setDbDirectory(File dbDirectory) throws IOException, IDMStoreException {
        this.cli = new StandaloneCommandLineInterface(dbDirectory);
    }

    @Override
    protected void listUsers() throws IDMStoreException {
        System.out.println("User names:");
        List<String> userNames = this.cli.getAllUserNames();
        for (String userName : userNames) {
            System.out.println(userName);
        }
    }

    @Override
    protected int resetPasswords(List<String> userNames, List<String> passwords) throws IDMStoreException {
        for (int i = 0; i < userNames.size(); ++i) {
            String newPassword;
            String userName = userNames.get(i);
            boolean isSuccess = this.cli.resetPassword(userName, newPassword = passwords.get(i));
            if (!isSuccess) {
                System.err.println("User does not exist: " + userName);
                return -4;
            }
            System.out.println(userName + "'s password has been changed");
        }
        return 0;
    }

    @Override
    protected int verifyUsers(List<String> userNames, List<String> passwords) throws IDMStoreException {
        for (int i = 0; i < userNames.size(); ++i) {
            String password;
            String userName = userNames.get(i);
            if (!this.cli.checkUserPassword(userName, password = passwords.get(i))) {
                System.out.println("NOK");
                return -7;
            }
            System.out.println("OK");
        }
        return 0;
    }

    @Override
    protected int deleteUsers(List<String> userNames) throws IDMStoreException {
        for (String userName : userNames) {
            if (this.cli.deleteUser(userName)) {
                System.out.print("User deleted");
                continue;
            }
            System.err.println("User does not exist: " + userName);
            return -4;
        }
        return 0;
    }

    @Override
    protected int addNewUsers(List<String> userNames, List<String> passwords, boolean areAdmins) throws IDMStoreException {
        for (int i = 0; i < userNames.size(); ++i) {
            String userName = userNames.get(i);
            String newPassword = passwords.get(i);
            this.cli.createNewUser(userName, newPassword, areAdmins);
            System.out.print("New user created");
            if (areAdmins) {
                System.out.print(", as admin");
            }
            System.out.println(": " + userName);
        }
        return 0;
    }
}

