/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cli.jar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.opendaylight.aaa.api.IDMStoreException;

public abstract class AbstractMain {
    private static final String OPTION_HELP = "h";
    private static final String OPTION_DB_DIR = "dbd";
    private static final String OPTION_LIST_USERS = "l";
    private static final String OPTION_CHANGE_USER = "cu";
    private static final String OPTION_NEW_USER = "nu";
    private static final String OPTION_DEL_USER = "du";
    private static final String OPTION_VERIFY_USER = "vu";
    private static final String OPTION_ADMINS = "a";
    private static final String OPTION_PASS = "p";
    private static final String OPTION_DEBUG = "X";
    private static final int RETURN_NOT_ENOUGH_ARGS = -1;
    private static final int RETURN_ABORT_DUE_TO_EXCEPTION = -2;
    private static final int RETURN_ARGUMENTS_MISMATCHED = -3;
    protected static final int RETURN_ILLEGAL_ARGUMENTS = -4;
    private static final int RETURN_ARGUMENTS_INCOMPATIBLE = -5;
    private static final int RETURN_ARGUMENTS_MISSING = -6;
    protected static final int RETURN_PASSWORD_MISMATCH = -7;

    public int parseArguments(String[] args) throws Exception {
        boolean isInDebugLogging = false;
        try {
            OptionParser optionParser = this.getOptionParser();
            OptionSet optionSet = optionParser.parse(args);
            if (optionSet.has(OPTION_DEBUG)) {
                isInDebugLogging = true;
            }
            if (!optionSet.nonOptionArguments().isEmpty()) {
                this.unrecognizedOptions(optionSet.nonOptionArguments());
            }
            if (args.length == 0 || optionSet.has(OPTION_HELP) || !optionSet.nonOptionArguments().isEmpty()) {
                this.printHelp(optionParser);
                return -1;
            }
            if (optionSet.has(OPTION_CHANGE_USER) && optionSet.has(OPTION_NEW_USER)) {
                System.err.println("Can't use these options together: -cu, -nu");
                return -5;
            }
            if (optionSet.has(OPTION_PASS) && !optionSet.has(OPTION_CHANGE_USER) && !optionSet.has(OPTION_VERIFY_USER) && !optionSet.has(OPTION_NEW_USER)) {
                System.err.println("If passwords are specificied, then must use one or the other of these options: -cu, -nu");
                return -6;
            }
            ArrayList<String> userNames = new ArrayList();
            if (optionSet.has(OPTION_CHANGE_USER)) {
                userNames = optionSet.valuesOf(OPTION_CHANGE_USER);
            } else if (optionSet.has(OPTION_NEW_USER)) {
                userNames = optionSet.valuesOf(OPTION_NEW_USER);
            } else if (optionSet.has(OPTION_DEL_USER)) {
                userNames = optionSet.valuesOf(OPTION_DEL_USER);
            } else if (optionSet.has(OPTION_VERIFY_USER)) {
                userNames = optionSet.valuesOf(OPTION_VERIFY_USER);
            }
            List<String> passwords = optionSet.valuesOf(OPTION_PASS);
            if (!optionSet.has(OPTION_DEL_USER) && passwords.size() != userNames.size()) {
                System.err.println("Must give as many user names as passwords");
                return -3;
            }
            File dbDirectory = (File)optionSet.valueOf(OPTION_DB_DIR);
            this.setDbDirectory(dbDirectory);
            if (optionSet.has(OPTION_DEL_USER)) {
                this.deleteUsers(userNames);
            }
            if (optionSet.has(OPTION_LIST_USERS)) {
                this.listUsers();
            }
            if (optionSet.has(OPTION_CHANGE_USER)) {
                return this.resetPasswords(userNames, passwords);
            }
            if (optionSet.has(OPTION_VERIFY_USER)) {
                return this.verifyUsers(userNames, passwords);
            }
            if (optionSet.has(OPTION_NEW_USER)) {
                boolean areAdmins = optionSet.has(OPTION_ADMINS);
                return this.addNewUsers(userNames, passwords, areAdmins);
            }
            return 0;
        }
        catch (Throwable t) {
            if (!isInDebugLogging) {
                System.err.println("Aborting due to " + t.getClass().getSimpleName() + " (use -X to see full stack trace): " + t.getMessage());
                return -2;
            }
            throw t;
        }
    }

    private OptionParser getOptionParser() {
        return new OptionParser(){
            {
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_HELP, "?"), "Show help").forHelp();
                this.accepts(AbstractMain.OPTION_DB_DIR, "databaseDirectory").withRequiredArg().ofType(File.class).defaultsTo(new File("."), (File[])new File[0]).describedAs("path");
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_LIST_USERS, "listUsers"), "List all existing users");
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_NEW_USER, "newUser"), "New user to create").withRequiredArg();
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_CHANGE_USER, "changeUser"), "Existing user name to change password").withRequiredArg();
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_DEL_USER, "deleteUser"), "Existing user name to delete").withRequiredArg();
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_VERIFY_USER, "verifyUser"), "Existing user name to verify password of").withRequiredArg();
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_PASS, "passwd"), "New password").withRequiredArg();
                this.accepts(AbstractMain.OPTION_ADMINS, "New User(s) added with 'admin' role");
                this.acceptsAll(Arrays.asList(AbstractMain.OPTION_DEBUG, "debug"), "Produce execution debug output");
                this.allowsUnrecognizedOptions();
            }
        };
    }

    protected void unrecognizedOptions(List<?> unrecognizedOptions) {
        System.err.println("Unrecognized options: " + unrecognizedOptions);
    }

    protected void printHelp(OptionParser optionParser) throws IOException {
        optionParser.printHelpOn(System.out);
    }

    protected abstract void setDbDirectory(File var1) throws IOException, IDMStoreException;

    protected abstract void listUsers() throws IDMStoreException;

    protected abstract int resetPasswords(List<String> var1, List<String> var2) throws IDMStoreException;

    protected abstract int verifyUsers(List<String> var1, List<String> var2) throws IDMStoreException;

    protected abstract int addNewUsers(List<String> var1, List<String> var2, boolean var3) throws IDMStoreException;

    protected abstract int deleteUsers(List<String> var1) throws IDMStoreException;
}

