/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IDMStoreUtil;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.Domain;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.Grants;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(StoreBuilder.class);
    private final IIDMStore store;

    public StoreBuilder(IIDMStore store) {
        this.store = store;
    }

    public String initDomainAndRolesWithoutUsers(String domainID) throws IDMStoreException {
        LOG.info("Checking if default entries must be created in IDM store");
        Domain defaultDomain = this.store.readDomain(domainID);
        if (defaultDomain != null) {
            LOG.info("Found default domain in IDM store, skipping insertion of default data");
            return null;
        }
        Domain domain = new Domain();
        domain.setEnabled(true);
        domain.setName("sdn");
        domain.setDescription("default odl sdn domain");
        domain = this.store.writeDomain(domain);
        LOG.info("Created default domain");
        String newDomainID = domain.getDomainid();
        Role adminRole = new Role();
        adminRole.setName("admin");
        adminRole.setDomainid(newDomainID);
        adminRole.setDescription("a role for admins");
        this.store.writeRole(adminRole);
        LOG.info("Created 'admin' role");
        Role userRole = new Role();
        userRole.setName("user");
        userRole.setDomainid(newDomainID);
        userRole.setDescription("a role for users");
        this.store.writeRole(userRole);
        LOG.info("Created 'user' role");
        return newDomainID;
    }

    public void initWithDefaultUsers(String domainID) throws IDMStoreException {
        String newDomainID = this.initDomainAndRolesWithoutUsers(domainID);
        if (newDomainID != null) {
            this.createUser(newDomainID, "admin", "admin", true);
        }
    }

    public List<String> getRoleIDs(String domainID, List<String> roleNames) throws IDMStoreException {
        HashMap<String, String> roleNameToID = new HashMap<String, String>();
        List<Role> roles = this.store.getRoles().getRoles();
        for (Role role : roles) {
            if (!domainID.equals(role.getDomainid())) continue;
            roleNameToID.put(role.getName(), role.getRoleid());
        }
        ArrayList<String> roleIDs = new ArrayList<String>(roleNames.size());
        for (String roleName : roleNames) {
            String roleID = (String)roleNameToID.get(roleName);
            if (roleID == null) {
                throw new IllegalStateException("'" + roleName + "' role not found (in domain '" + domainID + "')");
            }
            roleIDs.add(roleID);
        }
        return roleIDs;
    }

    public String createUser(String domainID, String userName, String password, List<String> roleIDs) throws IDMStoreException {
        User newUser = new User();
        newUser.setEnabled(true);
        newUser.setDomainid(domainID);
        newUser.setName(userName);
        newUser.setDescription(userName + " user");
        newUser.setEmail("");
        newUser.setPassword(password);
        newUser = this.store.writeUser(newUser);
        LOG.debug("Created '{}' user in domain '{}'", (Object)userName, (Object)domainID);
        String newUserID = newUser.getUserid();
        for (String roleID : roleIDs) {
            this.createGrant(domainID, newUserID, roleID);
        }
        return newUserID;
    }

    public String createUser(String domainID, String userName, String password, boolean isAdmin) throws IDMStoreException {
        List<String> roleIDs = isAdmin ? this.getRoleIDs(domainID, Arrays.asList("user", "admin")) : this.getRoleIDs(domainID, Arrays.asList("user"));
        return this.createUser(domainID, userName, password, roleIDs);
    }

    public boolean deleteUser(String domainID, String userName) throws IDMStoreException {
        String userID = IDMStoreUtil.createUserid(userName, domainID);
        Grants grants = this.store.getGrants(userID);
        for (Grant grant : grants.getGrants()) {
            this.store.deleteGrant(grant.getGrantid());
        }
        return this.store.deleteUser(userID) != null;
    }

    private void createGrant(String domainID, String userID, String roleID) throws IDMStoreException {
        Grant grant = new Grant();
        grant.setDomainid(domainID);
        grant.setUserid(userID);
        grant.setRoleid(roleID);
        this.store.writeGrant(grant);
        LOG.debug("Granted '{}' user the '{}' role in domain '{}'", userID, roleID, domainID);
    }
}

