/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMService;
import org.opendaylight.aaa.api.IdMServiceImpl;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.StoreBuilder;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.datastore.h2.H2TokenStore;
import org.opendaylight.aaa.shiro.moon.MoonTokenEndpoint;
import org.opendaylight.aaa.shiro.oauth2.OAuth2TokenServlet;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.HttpBasicAuth;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAAShiroProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AAAShiroProvider.class);
    public static final CompletableFuture<AAAShiroProvider> INSTANCE_FUTURE = new CompletableFuture();
    private final DataBroker dataBroker;
    private final ICertificateManager certificateManager;
    private final HttpService httpService;
    private final TokenStore tokenStore;
    private final ShiroConfiguration shiroConfiguration;
    private final String moonEndpointPath;
    private final String oauth2EndpointPath;
    private final TokenAuthenticators tokenAuthenticators;
    private final AuthenticationService authenticationService;
    private final PasswordHashService passwordHashService;

    public AAAShiroProvider(DataBroker dataBroker, ICertificateManager certificateManager, CredentialAuth<PasswordCredentials> credentialAuth, ShiroConfiguration shiroConfiguration, HttpService httpService, String moonEndpointPath, String oauth2EndpointPath, DatastoreConfig datastoreConfig, IIDMStore iidmStore, AuthenticationService authenticationService, PasswordHashService passwordHashService) {
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.shiroConfiguration = shiroConfiguration;
        this.httpService = httpService;
        this.moonEndpointPath = moonEndpointPath;
        this.oauth2EndpointPath = oauth2EndpointPath;
        this.authenticationService = authenticationService;
        this.passwordHashService = passwordHashService;
        if (datastoreConfig == null || !datastoreConfig.getStore().equals((Object)DatastoreConfig.Store.H2DataStore)) {
            LOG.info("AAA Datastore has not been initialized");
            this.tokenStore = null;
            this.tokenAuthenticators = new TokenAuthenticators(new TokenAuth[0]);
            return;
        }
        this.tokenStore = new H2TokenStore(datastoreConfig.getTimeToLive().longValue(), datastoreConfig.getTimeToWait().longValue());
        AAAShiroProvider.initializeIIDMStore(iidmStore);
        this.tokenAuthenticators = AAAShiroProvider.buildTokenAuthenticators(credentialAuth);
        try {
            this.registerServletContexts(credentialAuth, authenticationService, iidmStore);
        }
        catch (ServletException | NamespaceException e) {
            LOG.warn("Could not initialize AAA servlet endpoints", e);
        }
        INSTANCE_FUTURE.complete(this);
    }

    private static TokenAuthenticators buildTokenAuthenticators(CredentialAuth<PasswordCredentials> credentialAuth) {
        return new TokenAuthenticators(new HttpBasicAuth(credentialAuth));
    }

    private void registerServletContexts(CredentialAuth<PasswordCredentials> credentialAuth, AuthenticationService authService, IIDMStore iidmStore) throws ServletException, NamespaceException {
        LOG.info("attempting registration of AAA moon, oauth2 and auth servlets");
        Preconditions.checkNotNull(this.httpService, "httpService cannot be null");
        IdMServiceImpl idmService = new IdMServiceImpl(iidmStore);
        this.httpService.registerServlet(this.moonEndpointPath, (Servlet)new MoonTokenEndpoint(), null, null);
        this.httpService.registerServlet(this.oauth2EndpointPath, (Servlet)new OAuth2TokenServlet(credentialAuth, authService, this.tokenStore, (IdMService)idmService), null, null);
    }

    private static void initializeIIDMStore(IIDMStore iidmStore) {
        try {
            new StoreBuilder(iidmStore).initWithDefaultUsers("sdn");
        }
        catch (IDMStoreException e) {
            LOG.error("Failed to initialize data in store", e);
        }
    }

    public void init() {
        LOG.info("AAAShiroProvider Session Initiated");
    }

    public void close() {
        LOG.info("AAAShiroProvider Closed");
        if (this.httpService != null) {
            this.httpService.unregister(this.moonEndpointPath);
            this.httpService.unregister(this.oauth2EndpointPath);
        }
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public ICertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public ShiroConfiguration getShiroConfiguration() {
        return this.shiroConfiguration;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public TokenAuthenticators getTokenAuthenticators() {
        return this.tokenAuthenticators;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public PasswordHashService getPasswordHashService() {
        return this.passwordHashService;
    }
}

