/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.api.DatabaseEventListener;
import org.h2.api.JavaObjectSerializer;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.DbSettings;
import org.h2.engine.DelayedDatabaseCloser;
import org.h2.engine.Domain;
import org.h2.engine.Engine;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.OnExitDatabaseCloser;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.result.LocalResultFactory;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.security.auth.Authenticator;
import org.h2.store.DataHandler;
import org.h2.store.FileLock;
import org.h2.store.FileLockMethod;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LobStorageBackend;
import org.h2.store.LobStorageInterface;
import org.h2.store.LobStorageMap;
import org.h2.store.PageStore;
import org.h2.store.WriterThread;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveConcurrentMap;
import org.h2.value.CaseInsensitiveMap;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private static final boolean ASSERT;
    private static final ThreadLocal<Session> META_LOCK_DEBUGGING;
    private static final ThreadLocal<Database> META_LOCK_DEBUGGING_DB;
    private static final ThreadLocal<Throwable> META_LOCK_DEBUGGING_STACK;
    private static final Session[] EMPTY_SESSION_ARRAY;
    private static final String SYSTEM_USER_NAME = "DBA";
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final byte[] fileEncryptionKey;
    private final HashMap<String, Role> roles = new HashMap();
    private final HashMap<String, User> users = new HashMap();
    private final HashMap<String, Setting> settings = new HashMap();
    private final HashMap<String, Schema> schemas = new HashMap();
    private final HashMap<String, Right> rights = new HashMap();
    private final HashMap<String, Domain> domains = new HashMap();
    private final HashMap<String, UserAggregate> aggregates = new HashMap();
    private final HashMap<String, Comment> comments = new HashMap();
    private final HashMap<String, TableEngine> tableEngines = new HashMap();
    private final Set<Session> userSessions = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<Session> exclusiveSession = new AtomicReference();
    private final BitSet objectIds = new BitSet();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private int nextTempTableId;
    private User systemUser;
    private Session systemSession;
    private Session lobSession;
    private Table meta;
    private Index metaIdIndex;
    private FileLock lock;
    private WriterThread writer;
    private volatile boolean starting;
    private TraceSystem traceSystem;
    private Trace trace;
    private final FileLockMethod fileLockMethod;
    private Role publicRole;
    private final AtomicLong modificationDataId = new AtomicLong();
    private final AtomicLong modificationMetaId = new AtomicLong();
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = SysProperties.MAX_MEMORY_ROWS;
    private int maxMemoryUndo = 50000;
    private int lockMode = 3;
    private int maxLengthInplaceLob;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private volatile int closeDelay;
    private DelayedDatabaseCloser delayedCloser;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private final String cacheType;
    private final String accessModeData;
    private boolean referentialIntegrity = true;
    private Mode mode = Mode.getRegular();
    private boolean multiThreaded;
    private int maxOperationMemory = 100000;
    private SmallLRUCache<String, String[]> lobFileListCache;
    private final boolean autoServerMode;
    private final int autoServerPort;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private final TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;
    private Properties reconnectLastLock;
    private volatile long reconnectCheckNext;
    private volatile boolean reconnectChangePending;
    private volatile int checkpointAllowed;
    private volatile boolean checkpointRunning;
    private final Object reconnectSync = new Object();
    private int cacheSize;
    private int compactMode;
    private SourceCompiler compiler;
    private volatile boolean metaTablesInitialized;
    private boolean flushOnEachCommit;
    private LobStorageInterface lobStorage;
    private final int pageSize;
    private int defaultTableType = 0;
    private final DbSettings dbSettings;
    private final long reconnectCheckDelayNs;
    private int logMode;
    private MVTableEngine.Store store;
    private int retentionTime;
    private boolean allowBuiltinAliasOverride;
    private final AtomicReference<DbException> backgroundException = new AtomicReference();
    private JavaObjectSerializer javaObjectSerializer;
    private String javaObjectSerializerName;
    private volatile boolean javaObjectSerializerInitialized;
    private boolean queryStatistics;
    private int queryStatisticsMaxEntries = 100;
    private QueryStatisticsData queryStatisticsData;
    private RowFactory rowFactory = RowFactory.DEFAULT;
    private LocalResultFactory resultFactory = LocalResultFactory.DEFAULT;
    private Authenticator authenticator;

    public Database(ConnectionInfo connectionInfo, String string) {
        String string2;
        if (ASSERT) {
            META_LOCK_DEBUGGING.set(null);
            META_LOCK_DEBUGGING_DB.set(null);
            META_LOCK_DEBUGGING_STACK.set(null);
        }
        String string3 = connectionInfo.getName();
        this.dbSettings = connectionInfo.getDbSettings();
        this.reconnectCheckDelayNs = TimeUnit.MILLISECONDS.toNanos(this.dbSettings.reconnectCheckDelay);
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = connectionInfo.isPersistent();
        this.filePasswordHash = connectionInfo.getFilePasswordHash();
        this.fileEncryptionKey = connectionInfo.getFileEncryptionKey();
        this.databaseName = string3;
        this.databaseShortName = this.parseDatabaseShortName();
        this.maxLengthInplaceLob = 256;
        this.cipher = string;
        String string4 = connectionInfo.getProperty("FILE_LOCK", null);
        this.accessModeData = StringUtils.toLowerEnglish(connectionInfo.getProperty("ACCESS_MODE_DATA", "rw"));
        this.autoServerMode = connectionInfo.getProperty("AUTO_SERVER", false);
        this.autoServerPort = connectionInfo.getProperty("AUTO_SERVER_PORT", 0);
        int n = Utils.scaleForAvailableMemory(65536);
        this.cacheSize = connectionInfo.getProperty("CACHE_SIZE", n);
        this.pageSize = connectionInfo.getProperty("PAGE_SIZE", 4096);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
        }
        this.fileLockMethod = this.dbSettings.mvStore && string4 == null ? (this.autoServerMode ? FileLockMethod.FILE : FileLockMethod.FS) : FileLock.getFileLockMethod(string4);
        if (this.dbSettings.mvStore && this.fileLockMethod == FileLockMethod.SERIALIZED) {
            throw DbException.getUnsupportedException("MV_STORE combined with FILE_LOCK=SERIALIZED");
        }
        this.databaseURL = connectionInfo.getURL();
        String string5 = connectionInfo.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (string5 != null) {
            string5 = StringUtils.trim(string5, true, true, "'");
            this.setEventListenerClass(string5);
        }
        if ((string2 = connectionInfo.removeProperty("MODE", null)) != null) {
            this.mode = Mode.getInstance(string2);
            if (this.mode == null) {
                throw DbException.get(90088, string2);
            }
        }
        this.logMode = connectionInfo.getProperty("LOG", 2);
        this.javaObjectSerializerName = connectionInfo.getProperty("JAVA_OBJECT_SERIALIZER", null);
        this.multiThreaded = connectionInfo.getProperty("MULTI_THREADED", this.dbSettings.mvStore);
        this.allowBuiltinAliasOverride = connectionInfo.getProperty("BUILTIN_ALIAS_OVERRIDE", false);
        boolean bl = this.dbSettings.dbCloseOnExit;
        int n2 = connectionInfo.getIntProperty(10, 1);
        int n3 = connectionInfo.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(connectionInfo.removeProperty("CACHE_TYPE", "LRU"));
        this.openDatabase(n2, n3, bl, connectionInfo);
    }

    private void openDatabase(int n, int n2, boolean bl, ConnectionInfo connectionInfo) {
        try {
            this.open(n, n2, connectionInfo);
            if (bl) {
                OnExitDatabaseCloser.register(this);
            }
        }
        catch (Throwable throwable) {
            try {
                boolean bl2;
                if (throwable instanceof OutOfMemoryError) {
                    throwable.fillInStackTrace();
                }
                boolean bl3 = bl2 = throwable instanceof DbException && ((DbException)throwable).getErrorCode() == 90020;
                if (bl2) {
                    this.stopServer();
                }
                if (this.traceSystem != null) {
                    if (throwable instanceof DbException && !bl2) {
                        this.trace.error(throwable, "opening {0}", this.databaseName);
                    }
                    this.traceSystem.close();
                }
                this.closeOpenFilesAndUnlock(false);
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw DbException.convert(throwable);
        }
    }

    public int getLockTimeout() {
        Setting setting = this.findSetting(SetTypes.getTypeName(6));
        return setting == null ? 2000 : setting.getIntValue();
    }

    public Row createRow(Value[] valueArray, int n) {
        return this.rowFactory.createRow(valueArray, n);
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(RowFactory rowFactory) {
        this.rowFactory = rowFactory;
    }

    public LocalResultFactory getResultFactory() {
        return this.resultFactory;
    }

    public void setResultFactory(LocalResultFactory localResultFactory) {
        this.resultFactory = localResultFactory;
    }

    public static void setInitialPowerOffCount(int n) {
        initialPowerOffCount = n;
    }

    public void setPowerOffCount(int n) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = n;
    }

    public MVTableEngine.Store getStore() {
        return this.store;
    }

    public void setStore(MVTableEngine.Store store) {
        this.store = store;
        this.retentionTime = store.getMvStore().getRetentionTime();
    }

    public boolean areEqual(Value value, Value value2) {
        return value.compareTo(value2, this.mode, this.compareMode) == 0;
    }

    public int compare(Value value, Value value2) {
        return value.compareTo(value2, this.mode, this.compareMode);
    }

    public int compareWithNull(Value value, Value value2, boolean bl) {
        return value.compareWithNull(value2, bl, this.mode, this.compareMode);
    }

    public int compareTypeSafe(Value value, Value value2) {
        return value.compareTypeSafe(value2, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId.get();
    }

    private synchronized boolean reconnectModified(boolean bl) {
        if (this.readOnly || this.lock == null || this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return true;
        }
        try {
            Object object;
            if (bl == this.reconnectChangePending) {
                long l = System.nanoTime();
                if (l > this.reconnectCheckNext) {
                    if (bl) {
                        String string = this.pageStore == null ? null : Long.toString(this.pageStore.getWriteCountTotal());
                        this.lock.setProperty("logPos", string);
                        this.lock.save();
                    }
                    this.reconnectCheckNext = l + this.reconnectCheckDelayNs;
                }
                return true;
            }
            Properties properties = this.lock.load();
            if (bl) {
                if (properties.getProperty("changePending") != null) {
                    return false;
                }
                this.trace.debug("wait before writing");
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis((long)((double)this.reconnectCheckDelayNs * 1.1)));
                object = this.lock.load();
                if (!((Properties)object).equals(properties)) {
                    return false;
                }
            }
            object = this.pageStore == null ? null : Long.toString(this.pageStore.getWriteCountTotal());
            this.lock.setProperty("logPos", (String)object);
            if (bl) {
                this.lock.setProperty("changePending", "true-" + Math.random());
            } else {
                this.lock.setProperty("changePending", null);
            }
            this.reconnectCheckNext = System.nanoTime() + 2L * this.reconnectCheckDelayNs;
            properties = this.lock.save();
            if (bl) {
                this.trace.debug("wait before writing again");
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis((long)((double)this.reconnectCheckDelayNs * 1.1)));
                Properties properties2 = this.lock.load();
                if (!properties2.equals(properties)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.reconnectLastLock = properties;
            this.reconnectChangePending = bl;
            this.reconnectCheckNext = System.nanoTime() + this.reconnectCheckDelayNs;
            return true;
        }
        catch (Exception exception) {
            this.trace.error(exception, "pending {0}", bl);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return this.modificationDataId.incrementAndGet();
    }

    public long getModificationMetaId() {
        return this.modificationMetaId.get();
    }

    public long getNextModificationMetaId() {
        this.modificationDataId.incrementAndGet();
        return this.modificationMetaId.incrementAndGet() - 1L;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPowerOff() {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                this.stopWriter();
                if (this.store != null) {
                    this.store.closeImmediately();
                }
                Database database = this;
                synchronized (database) {
                    if (this.pageStore != null) {
                        try {
                            this.pageStore.close();
                        }
                        catch (DbException dbException) {
                            // empty catch block
                        }
                        this.pageStore = null;
                    }
                }
                if (this.lock != null) {
                    this.stopServer();
                    if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
                        this.lock.unlock();
                    }
                    this.lock = null;
                }
                if (this.traceSystem != null) {
                    this.traceSystem.close();
                }
            }
            catch (DbException dbException) {
                DbException.traceThrowable(dbException);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw DbException.get(90098);
    }

    static boolean exists(String string) {
        if (FileUtils.exists(string + ".h2.db")) {
            return true;
        }
        return FileUtils.exists(string + ".mv.db");
    }

    public Trace getTrace(int n) {
        return this.traceSystem.getTrace(n);
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        if (bl && !FileUtils.exists(string)) {
            throw DbException.get(90124, string);
        }
        FileStore fileStore = FileStore.open(this, string, string2, this.cipher, this.filePasswordHash);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    boolean validateFilePasswordHash(String string, byte[] byArray) {
        if (!Objects.equals(string, this.cipher)) {
            return false;
        }
        return Utils.compareSecure(byArray, this.filePasswordHash);
    }

    private String parseDatabaseShortName() {
        String string = this.databaseName;
        if (string.endsWith(":")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\:,;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        if (string == null || string.isEmpty()) {
            string = "unnamed";
        }
        return this.dbSettings.databaseToUpper ? StringUtils.toUpperEnglish(string) : (this.dbSettings.databaseToLower ? StringUtils.toLowerEnglish(string) : string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void open(int n, int n2, ConnectionInfo connectionInfo) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.persistent) {
            object5 = this.databaseName + ".data.db";
            boolean bl = FileUtils.exists((String)object5);
            object4 = this.databaseName + ".h2.db";
            String string = this.databaseName + ".mv.db";
            boolean bl2 = FileUtils.exists((String)object4);
            boolean bl3 = FileUtils.exists(string);
            if (bl && !bl2 && !bl3) {
                throw DbException.get(90048, "Old database: " + (String)object5 + " - please convert the database " + "to a SQL script and re-create it.");
            }
            if (bl2 && !FileUtils.canWrite((String)object4)) {
                this.readOnly = true;
            }
            if (bl3 && !FileUtils.canWrite(string)) {
                this.readOnly = true;
            }
            if (bl2 && !bl3) {
                this.dbSettings.mvStore = false;
                this.multiThreaded = connectionInfo.getProperty("MULTI_THREADED", false);
            }
            if (this.readOnly) {
                if (n >= 3) {
                    object3 = Utils.getProperty("java.io.tmpdir", ".") + "/" + "h2_" + System.currentTimeMillis();
                    this.traceSystem = new TraceSystem((String)object3 + ".trace.db");
                } else {
                    this.traceSystem = new TraceSystem(null);
                }
            } else {
                this.traceSystem = new TraceSystem(this.databaseName + ".trace.db");
            }
            this.traceSystem.setLevelFile(n);
            this.traceSystem.setLevelSystemOut(n2);
            this.trace = this.traceSystem.getTrace(2);
            this.trace.info("opening {0} (build {1})", this.databaseName, 199);
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == FileLockMethod.NO || this.fileLockMethod == FileLockMethod.SERIALIZED || this.fileLockMethod == FileLockMethod.FS)) {
                throw DbException.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO || fileLockMethod == SERIALIZED || fileLockMethod == FS || inMemory)");
            }
            object3 = this.databaseName + ".lock.db";
            if (this.readOnly && FileUtils.exists((String)object3)) {
                throw DbException.get(90020, "Lock file exists: " + (String)object3);
            }
            if (!this.readOnly && this.fileLockMethod != FileLockMethod.NO && this.fileLockMethod != FileLockMethod.FS) {
                this.lock = new FileLock(this.traceSystem, (String)object3, 1000);
                this.lock.lock(this.fileLockMethod);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            if (SysProperties.MODIFY_ON_WRITE) {
                while (this.isReconnectNeeded()) {
                }
            } else {
                while (this.isReconnectNeeded() && !this.beforeWriting()) {
                }
            }
            this.deleteOldTempFiles();
            this.starting = true;
            if (SysProperties.MODIFY_ON_WRITE) {
                try {
                    this.getPageStore();
                }
                catch (DbException dbException) {
                    if (dbException.getErrorCode() != 90097) {
                        throw dbException;
                    }
                    this.pageStore = null;
                    while (!this.beforeWriting()) {
                    }
                    this.getPageStore();
                }
            } else {
                this.getPageStore();
            }
            this.starting = false;
            if (this.store == null) {
                this.writer = WriterThread.create(this, this.writeDelay);
            } else {
                this.setWriteDelay(this.writeDelay);
            }
        } else {
            if (this.autoServerMode) {
                throw DbException.getUnsupportedException("autoServerMode && inMemory");
            }
            this.traceSystem = new TraceSystem(null);
            this.trace = this.traceSystem.getTrace(2);
            if (this.dbSettings.mvStore) {
                this.getPageStore();
            }
        }
        if (this.store != null) {
            this.store.getTransactionStore().init();
        }
        this.systemUser = new User(this, 0, SYSTEM_USER_NAME, true);
        this.mainSchema = new Schema(this, 0, this.sysIdentifier("PUBLIC"), this.systemUser, true);
        this.infoSchema = new Schema(this, -1, this.sysIdentifier("INFORMATION_SCHEMA"), this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, this.sysIdentifier("PUBLIC"), true);
        this.roles.put(this.publicRole.getName(), this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        this.lobSession = new Session(this, this.systemUser, ++this.nextSessionId);
        object5 = new CreateTableData();
        ArrayList<Column> arrayList = ((CreateTableData)object5).columns;
        object4 = new Column("ID", 4);
        ((Column)object4).setNullable(false);
        arrayList.add((Column)object4);
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("SQL", 13));
        boolean bl = true;
        if (this.pageStore != null) {
            bl = this.pageStore.isNew();
        }
        ((CreateTableData)object5).tableName = "SYS";
        ((CreateTableData)object5).id = 0;
        ((CreateTableData)object5).temporary = false;
        ((CreateTableData)object5).persistData = this.persistent;
        ((CreateTableData)object5).persistIndexes = this.persistent;
        ((CreateTableData)object5).create = bl;
        ((CreateTableData)object5).isHidden = true;
        ((CreateTableData)object5).session = this.systemSession;
        this.starting = true;
        this.meta = this.mainSchema.createTable((CreateTableData)object5);
        this.handleUpgradeIssues();
        IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{object4});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, indexColumnArray, IndexType.createPrimaryKey(false, false), true, null);
        this.systemSession.commit(true);
        this.objectIds.set(0);
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        object3 = new ArrayList((int)this.metaIdIndex.getRowCountApproximation());
        while (cursor.next()) {
            object2 = new MetaRecord(cursor.get());
            this.objectIds.set(((MetaRecord)object2).getId());
            ((ArrayList)object3).add(object2);
        }
        Collections.sort(object3);
        object2 = this.systemSession;
        synchronized (object2) {
            object = ((ArrayList)object3).iterator();
            while (object.hasNext()) {
                MetaRecord metaRecord = (MetaRecord)object.next();
                metaRecord.execute(this, this.systemSession, this.eventListener);
            }
        }
        this.systemSession.commit(true);
        if (this.store != null) {
            this.store.getTransactionStore().endLeftoverTransactions();
            this.store.removeTemporaryMaps(this.objectIds);
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        if (!this.readOnly) {
            object2 = SetTypes.getTypeName(33);
            if (this.settings.get(object2) == null) {
                object = new Setting(this, this.allocateObjectId(), (String)object2);
                ((Setting)object).setIntValue(199);
                this.lockMeta(this.systemSession);
                this.addDatabaseObject(this.systemSession, (DbObject)object);
            }
            this.setSortSetting(37, SysProperties.SORT_BINARY_UNSIGNED, true);
            this.setSortSetting(50, SysProperties.SORT_UUID_UNSIGNED, false);
            if (this.pageStore != null) {
                object = this.pageStore.getObjectIds();
                int n3 = ((BitSet)object).length();
                for (int i = 0; i < n3; ++i) {
                    if (!((BitSet)object).get(i) || this.objectIds.get(i)) continue;
                    this.trace.info("unused object id: " + i);
                    this.objectIds.set(i);
                }
            }
        }
        this.getLobStorage().init();
        this.systemSession.commit(true);
        this.trace.info("opened {0}", this.databaseName);
        if (this.checkpointAllowed > 0) {
            this.afterWriting();
        }
    }

    private void setSortSetting(int n, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        String string = SetTypes.getTypeName(n);
        if (this.settings.get(string) == null) {
            Setting setting = new Setting(this, this.allocateObjectId(), string);
            setting.setStringValue(bl ? "UNSIGNED" : "SIGNED");
            this.lockMeta(this.systemSession);
            this.addDatabaseObject(this.systemSession, setting);
        }
    }

    private void handleUpgradeIssues() {
        MVStore mVStore;
        if (this.store != null && !this.isReadOnly() && (mVStore = this.store.getMvStore()).hasMap("index.0")) {
            Row[] rowArray;
            Index index = this.meta.getScanIndex(this.systemSession);
            Cursor cursor = index.find(this.systemSession, null, null);
            ArrayList<Row[]> arrayList = new ArrayList<Row[]>();
            boolean bl = false;
            while (cursor.next()) {
                rowArray = cursor.get();
                arrayList.add(rowArray);
                long l = rowArray.getKey();
                int n = rowArray.getValue(0).getInt();
                if ((long)n == l) continue;
                bl = true;
                rowArray.setKey(n);
            }
            if (bl) {
                rowArray = arrayList.toArray(new Row[0]);
                Arrays.sort(rowArray, new Comparator<Row>(){

                    @Override
                    public int compare(Row row, Row row2) {
                        return Integer.compare(row.getValue(0).getInt(), row2.getValue(0).getInt());
                    }
                });
                this.meta.truncate(this.systemSession);
                for (Row row : rowArray) {
                    this.meta.addRow(this.systemSession, row);
                }
                this.systemSession.commit(true);
            }
            mVStore.removeMap("index.0");
            mVStore.commit();
        }
    }

    private void startServer(String string) {
        try {
            this.server = Server.createTcpServer((String[])new String[]{"-tcpPort", Integer.toString(this.autoServerPort), "-tcpAllowOthers", "-tcpDaemon", "-key", string, this.databaseName});
            this.server.start();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        String string2 = NetUtils.getLocalAddress();
        String string3 = string2 + ":" + this.server.getPort();
        this.lock.setProperty("server", string3);
        String string4 = NetUtils.getHostName(string2);
        this.lock.setProperty("hostName", string4);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server server = this.server;
            this.server = null;
            server.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        boolean bl;
        do {
            bl = false;
            for (Table table : this.getAllTablesAndViews(false)) {
                TableView tableView;
                if (!(table instanceof TableView) || !(tableView = (TableView)table).isInvalid()) continue;
                tableView.recompile(session, true, false);
                if (tableView.isInvalid()) continue;
                bl = true;
            }
        } while (bl);
        TableView.clearIndexCaches(session.getDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaTables() {
        if (this.metaTablesInitialized) {
            return;
        }
        Schema schema = this.infoSchema;
        synchronized (schema) {
            if (!this.metaTablesInitialized) {
                int n = MetaTable.getMetaTableTypeCount();
                for (int i = 0; i < n; ++i) {
                    MetaTable metaTable = new MetaTable(this.infoSchema, -1 - i, i);
                    this.infoSchema.add(metaTable);
                }
                this.metaTablesInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMeta(Session session, DbObject dbObject) {
        assert (Thread.holdsLock(this));
        int n = dbObject.getId();
        if (n > 0 && !this.starting && !dbObject.isTemporary()) {
            Row row = this.meta.getTemplateRow();
            MetaRecord.populateRowFromDBObject(dbObject, row);
            BitSet bitSet = this.objectIds;
            synchronized (bitSet) {
                this.objectIds.set(n);
            }
            if (SysProperties.CHECK) {
                this.verifyMetaLocked(session);
            }
            this.meta.addRow(session, row);
        }
    }

    public void verifyMetaLocked(Session session) {
        if (this.meta != null && !this.meta.isLockedExclusivelyBy(session) && this.lockMode != 0) {
            throw DbException.throwInternalError();
        }
    }

    public boolean lockMeta(Session session) {
        if (this.meta == null) {
            return true;
        }
        if (ASSERT && META_LOCK_DEBUGGING_DB.get() != null && META_LOCK_DEBUGGING_DB.get() != this) {
            Session session2 = META_LOCK_DEBUGGING.get();
            if (session2 == null) {
                META_LOCK_DEBUGGING.set(session);
                META_LOCK_DEBUGGING_DB.set(this);
                META_LOCK_DEBUGGING_STACK.set(new Throwable("Last meta lock granted in this stack trace, this is debug information for following IllegalStateException"));
            } else if (session2 != session) {
                META_LOCK_DEBUGGING_STACK.get().printStackTrace();
                throw new IllegalStateException("meta currently locked by " + session2 + ", sessionid=" + session2.getId() + " and trying to be locked by different session, " + session + ", sessionid=" + session.getId() + " on same thread");
            }
        }
        return this.meta.lock(session, true, true);
    }

    public void unlockMeta(Session session) {
        if (this.meta != null) {
            this.unlockMetaDebug(session);
            this.meta.unlock(session);
            session.unlock(this.meta);
        }
    }

    public void unlockMetaDebug(Session session) {
        if (ASSERT && META_LOCK_DEBUGGING.get() == session) {
            META_LOCK_DEBUGGING.set(null);
            META_LOCK_DEBUGGING_DB.set(null);
            META_LOCK_DEBUGGING_STACK.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMeta(Session session, int n) {
        if (n > 0 && !this.starting) {
            Object object;
            SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
            searchRow.setValue(0, ValueInt.get(n));
            boolean bl = this.lockMeta(session);
            try {
                object = this.metaIdIndex.find(session, searchRow, searchRow);
                if (object.next()) {
                    if (this.lockMode != 0 && !bl) {
                        throw DbException.throwInternalError();
                    }
                    Row row = object.get();
                    this.meta.removeRow(session, row);
                    if (SysProperties.CHECK) {
                        this.checkMetaFree(session, n);
                    }
                }
            }
            finally {
                if (!bl) {
                    this.unlockMeta(session);
                }
            }
            if (this.isMVStore()) {
                session.scheduleDatabaseObjectIdForRelease(n);
            } else {
                object = this;
                synchronized (object) {
                    this.objectIds.clear(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseDatabaseObjectIds(BitSet bitSet) {
        BitSet bitSet2 = this.objectIds;
        synchronized (bitSet2) {
            this.objectIds.andNot(bitSet);
        }
    }

    private HashMap<String, DbObject> getMap(int n) {
        HashMap<String, DbObject> hashMap;
        switch (n) {
            case 2: {
                hashMap = this.users;
                break;
            }
            case 6: {
                hashMap = this.settings;
                break;
            }
            case 7: {
                hashMap = this.roles;
                break;
            }
            case 8: {
                hashMap = this.rights;
                break;
            }
            case 10: {
                hashMap = this.schemas;
                break;
            }
            case 12: {
                hashMap = this.domains;
                break;
            }
            case 13: {
                hashMap = this.comments;
                break;
            }
            case 14: {
                hashMap = this.aggregates;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(Session session, SchemaObject schemaObject) {
        int n = schemaObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        this.lockMeta(session);
        Database database = this;
        synchronized (database) {
            schemaObject.getSchema().add(schemaObject);
            this.addMeta(session, schemaObject);
        }
    }

    public synchronized void addDatabaseObject(Session session, DbObject dbObject) {
        Object object;
        int n = dbObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap<String, DbObject> hashMap = this.getMap(dbObject.getType());
        if (dbObject.getType() == 2 && ((User)(object = (User)dbObject)).isAdmin() && this.systemUser.getName().equals(SYSTEM_USER_NAME)) {
            this.systemUser.rename(((DbObjectBase)object).getName());
        }
        object = dbObject.getName();
        if (SysProperties.CHECK && hashMap.get(object) != null) {
            DbException.throwInternalError("object already exists");
        }
        this.lockMeta(session);
        this.addMeta(session, dbObject);
        hashMap.put((String)object, dbObject);
    }

    public UserAggregate findAggregate(String string) {
        return this.aggregates.get(string);
    }

    public Comment findComment(DbObject dbObject) {
        if (dbObject.getType() == 13) {
            return null;
        }
        String string = Comment.getKey(dbObject);
        return this.comments.get(string);
    }

    public Role findRole(String string) {
        return this.roles.get(StringUtils.toUpperEnglish(string));
    }

    public Schema findSchema(String string) {
        Schema schema = this.schemas.get(string);
        if (schema == this.infoSchema) {
            this.initMetaTables();
        }
        return schema;
    }

    public Setting findSetting(String string) {
        return this.settings.get(string);
    }

    public User findUser(String string) {
        return this.users.get(StringUtils.toUpperEnglish(string));
    }

    public Domain findDomain(String string) {
        return this.domains.get(string);
    }

    public User getUser(String string) {
        User user = this.findUser(string);
        if (user == null) {
            throw DbException.get(90032, string);
        }
        return user;
    }

    synchronized Session createSession(User user) {
        if (this.closing) {
            return null;
        }
        if (this.exclusiveSession.get() != null) {
            throw DbException.get(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.trace.info("connecting session #{0} to {1}", session.getId(), this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            this.exclusiveSession.compareAndSet(session, null);
            this.userSessions.remove(session);
            if (session != this.systemSession && session != this.lobSession) {
                this.trace.info("disconnecting session #{0}", session.getId());
            }
        }
        if (this.userSessions.isEmpty() && session != this.systemSession && session != this.lobSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DelayedDatabaseCloser(this, this.closeDelay * 1000);
            }
        }
        if (session != this.systemSession && session != this.lobSession && session != null) {
            this.trace.info("disconnected session #{0}", session.getId());
        }
    }

    private synchronized void closeAllSessionsException(Session session) {
        Session[] sessionArray;
        for (Session session2 : sessionArray = this.userSessions.toArray(EMPTY_SESSION_ARRAY)) {
            if (session2 == session) continue;
            try {
                session2.close();
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "disconnecting session #{0}", session2.getId());
            }
        }
    }

    void close(boolean bl) {
        DbException dbException = this.backgroundException.getAndSet(null);
        try {
            this.closeImpl(bl);
        }
        catch (Throwable throwable) {
            if (dbException != null) {
                throwable.addSuppressed(dbException);
            }
            throw throwable;
        }
        if (dbException != null) {
            throw DbException.get(dbException.getErrorCode(), dbException, dbException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeImpl(boolean var1_1) {
        block33: {
            var2_2 = this;
            synchronized (var2_2) {
                if (this.closing) {
                    // MONITOREXIT @DISABLED, blocks:[0, 12, 30] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                    Engine.getInstance().close(this.databaseName);
                    return;
                }
                if (this.fileLockMethod != FileLockMethod.SERIALIZED || this.reconnectChangePending) ** break block32
            }
            {
                try {
                    this.closeOpenFilesAndUnlock(false);
                }
                catch (DbException var3_6) {
                    // empty catch block
                }
                this.traceSystem.close();
            }
            Engine.getInstance().close(this.databaseName);
            return;
            {
                this.closing = true;
                this.stopServer();
                if (!this.userSessions.isEmpty()) {
                    if (!var1_1) {
                        // MONITOREXIT @DISABLED, blocks:[12, 28, 29] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                        Engine.getInstance().close(this.databaseName);
                        return;
                    }
                    this.trace.info("closing {0} from shutdown hook", new Object[]{this.databaseName});
                    this.closeAllSessionsException(null);
                }
                this.trace.info("closing {0}", new Object[]{this.databaseName});
                if (this.eventListener != null) {
                    this.closing = false;
                    var3_7 = this.eventListener;
                    this.eventListener = null;
                    var3_7.closingDatabase();
                    if (!this.userSessions.isEmpty()) {
                        // MONITOREXIT @DISABLED, blocks:[26, 27, 12] lbl37 : MonitorExitStatement: MONITOREXIT : var2_2
                        Engine.getInstance().close(this.databaseName);
                        return;
                    }
                    ** try [egrp 6[TRYBLOCK] [15 : 208->544)] { 
lbl41:
                    // 1 sources

                    this.closing = true;
                }
                if (!this.isReadOnly()) {
                    this.removeOrphanedLobs();
                }
            }
            try {
                if (this.systemSession == null) break block33;
                if (this.powerOffCount != -1) {
                    for (Table var3_9 : this.getAllTablesAndViews(false)) {
                        if (var3_9.isGlobalTemporary()) {
                            var3_9.removeChildrenAndResources(this.systemSession);
                            continue;
                        }
                        var3_9.close(this.systemSession);
                    }
                    for (SchemaObject var3_11 : this.getAllSchemaObjects(3)) {
                        var4_15 = (Sequence)var3_11;
                        var4_15.close();
                    }
                }
                for (SchemaObject var3_13 : this.getAllSchemaObjects(4)) {
                    var4_15 = (TriggerObject)var3_13;
                    try {
                        var4_15.close();
                    }
                    catch (SQLException var5_16) {
                        this.trace.error(var5_16, "close");
                    }
                }
                if (this.powerOffCount != -1) {
                    this.meta.close(this.systemSession);
                    this.systemSession.commit(true);
                }
            }
            catch (DbException var2_3) {
                this.trace.error(var2_3, "close");
            }
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock(true);
        }
        catch (DbException var2_4) {
            this.trace.error(var2_4, "close");
        }
        this.trace.info("closed");
        this.traceSystem.close();
        OnExitDatabaseCloser.unregister(this);
        if (this.deleteFilesOnDisconnect == false) return;
        if (this.persistent == false) return;
        this.deleteFilesOnDisconnect = false;
        try {
            var2_2 = FileUtils.getParent(this.databaseName);
            var3_14 = FileUtils.getName(this.databaseName);
            DeleteDbFiles.execute((String)var2_2, (String)var3_14, (boolean)true);
            return;
        }
        catch (Exception var2_5) {
            // empty catch block
            return;
        }
lbl-1000:
        // 1 sources

        {
            finally {
                Engine.getInstance().close(this.databaseName);
            }
        }
    }

    private void removeOrphanedLobs() {
        if (!this.persistent) {
            return;
        }
        boolean bl = this.infoSchema.findTableOrView(this.systemSession, "LOB_DATA") != null;
        if (!(bl |= this.store != null)) {
            return;
        }
        try {
            this.getLobStorage();
            this.lobStorage.removeAllForTable(-1);
        }
        catch (DbException dbException) {
            this.trace.error(dbException, "close");
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            this.writer.stopThread();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeOpenFilesAndUnlock(boolean bl) {
        try {
            MVStore mVStore;
            boolean bl2;
            this.stopWriter();
            if (this.pageStore != null && bl) {
                try {
                    this.pageStore.checkpoint();
                    if (!this.readOnly) {
                        this.lockMeta(this.pageStore.getPageStoreSession());
                        this.pageStore.compact(this.compactMode);
                        this.unlockMeta(this.pageStore.getPageStoreSession());
                    }
                }
                catch (DbException dbException) {
                    if (ASSERT && !(bl2 = dbException.getErrorCode()) && !bl2 && !bl2) {
                        dbException.printStackTrace();
                    }
                    this.trace.error(dbException, "close");
                }
                catch (Throwable throwable) {
                    if (ASSERT) {
                        throwable.printStackTrace();
                    }
                    this.trace.error(throwable, "close");
                }
            }
            this.reconnectModified(false);
            if (this.store != null && (mVStore = this.store.getMvStore()) != null && !mVStore.isClosed()) {
                boolean bl3 = bl2 = this.compactMode == 82 || this.compactMode == 84 || this.getSettings().defragAlways;
                if (!bl2 && !mVStore.isReadOnly()) {
                    if (this.dbSettings.maxCompactTime > 0) {
                        try {
                            this.store.compactFile(this.dbSettings.maxCompactTime);
                        }
                        catch (Throwable throwable) {
                            this.trace.error(throwable, "compactFile");
                        }
                    } else {
                        mVStore.commit();
                    }
                }
                this.store.close(bl2);
            }
            if (this.systemSession != null) {
                this.systemSession.close();
                this.systemSession = null;
            }
            if (this.lobSession != null) {
                this.lobSession.close();
                this.lobSession = null;
            }
            this.closeFiles();
            if (this.persistent && this.lock == null && this.fileLockMethod != FileLockMethod.NO && this.fileLockMethod != FileLockMethod.FS) {
                return;
            }
            if (this.persistent) {
                this.deleteOldTempFiles();
            }
        }
        finally {
            if (this.lock != null) {
                if (this.fileLockMethod == FileLockMethod.SERIALIZED && this.lock.load().containsKey("changePending")) {
                    try {
                        Thread.sleep(TimeUnit.NANOSECONDS.toMillis((long)((double)this.reconnectCheckDelayNs * 1.1)));
                    }
                    catch (InterruptedException interruptedException) {
                        this.trace.error(interruptedException, "close");
                    }
                }
                this.lock.unlock();
                this.lock = null;
            }
        }
    }

    private synchronized void closeFiles() {
        try {
            if (this.store != null) {
                this.store.closeImmediately();
            }
            if (this.pageStore != null) {
                this.pageStore.close();
                this.pageStore = null;
            }
        }
        catch (DbException dbException) {
            this.trace.error(dbException, "close");
        }
    }

    private void checkMetaFree(Session session, int n) {
        SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n));
        Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
        if (cursor.next()) {
            DbException.throwInternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateObjectId() {
        int n;
        Object object;
        Object object2 = object = this.isMVStore() ? this.objectIds : this;
        synchronized (object2) {
            n = this.objectIds.nextClearBit(0);
            this.objectIds.set(n);
        }
        return n;
    }

    public Schema getMainSchema() {
        return this.mainSchema;
    }

    public ArrayList<UserAggregate> getAllAggregates() {
        return new ArrayList<UserAggregate>(this.aggregates.values());
    }

    public ArrayList<Comment> getAllComments() {
        return new ArrayList<Comment>(this.comments.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ArrayList<Right> getAllRights() {
        return new ArrayList<Right>(this.rights.values());
    }

    public ArrayList<Role> getAllRoles() {
        return new ArrayList<Role>(this.roles.values());
    }

    public ArrayList<SchemaObject> getAllSchemaObjects() {
        this.initMetaTables();
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        for (Schema schema : this.schemas.values()) {
            schema.getAll(arrayList);
        }
        return arrayList;
    }

    public ArrayList<SchemaObject> getAllSchemaObjects(int n) {
        if (n == 0) {
            this.initMetaTables();
        }
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        for (Schema schema : this.schemas.values()) {
            schema.getAll(n, arrayList);
        }
        return arrayList;
    }

    public ArrayList<Table> getAllTablesAndViews(boolean bl) {
        if (bl) {
            this.initMetaTables();
        }
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAllTablesAndViews());
        }
        return arrayList;
    }

    public ArrayList<TableSynonym> getAllSynonyms() {
        ArrayList<TableSynonym> arrayList = new ArrayList<TableSynonym>();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAllSynonyms());
        }
        return arrayList;
    }

    public ArrayList<Table> getTableOrViewByName(String string) {
        ArrayList<Table> arrayList = new ArrayList<Table>(1);
        for (Schema schema : this.schemas.values()) {
            Table table = schema.getTableOrViewByName(string);
            if (table == null) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    public ArrayList<Schema> getAllSchemas() {
        this.initMetaTables();
        return new ArrayList<Schema>(this.schemas.values());
    }

    public ArrayList<Setting> getAllSettings() {
        return new ArrayList<Setting>(this.settings.values());
    }

    public ArrayList<Domain> getAllDomains() {
        return new ArrayList<Domain>(this.domains.values());
    }

    public ArrayList<User> getAllUsers() {
        return new ArrayList<User>(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public String getCluster() {
        return this.cluster;
    }

    @Override
    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.toRealPath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean bl) {
        ArrayList<Session> arrayList;
        Object object = this.userSessions;
        synchronized (object) {
            arrayList = new ArrayList<Session>(this.userSessions);
        }
        object = this.systemSession;
        Session session = this.lobSession;
        if (bl && object != null) {
            arrayList.add((Session)object);
        }
        if (bl && session != null) {
            arrayList.add(session);
        }
        return arrayList.toArray(new Session[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeta(Session session, DbObject dbObject) {
        if (this.isMVStore()) {
            int n = dbObject.getId();
            if (n > 0) {
                Object object;
                if (!this.starting && !dbObject.isTemporary()) {
                    object = this.meta.getTemplateRow();
                    MetaRecord.populateRowFromDBObject(dbObject, (SearchRow)object);
                    Row row = this.metaIdIndex.getRow(session, n);
                    if (row != null) {
                        this.meta.updateRow(session, row, (Row)object);
                    }
                }
                object = this.objectIds;
                synchronized (object) {
                    this.objectIds.set(n);
                }
            }
        } else {
            boolean bl = this.lockMeta(session);
            Database database = this;
            synchronized (database) {
                int n = dbObject.getId();
                this.removeMeta(session, n);
                this.addMeta(session, dbObject);
                if (n > 0) {
                    this.objectIds.set(n);
                }
            }
            if (!bl) {
                this.unlockMeta(session);
            }
        }
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject schemaObject, String string) {
        this.checkWritingAllowed();
        schemaObject.getSchema().rename(schemaObject, string);
        this.updateMetaAndFirstLevelChildren(session, schemaObject);
    }

    private synchronized void updateMetaAndFirstLevelChildren(Session session, DbObject dbObject) {
        ArrayList<DbObject> arrayList = dbObject.getChildren();
        Comment comment = this.findComment(dbObject);
        if (comment != null) {
            DbException.throwInternalError(comment.toString());
        }
        this.updateMeta(session, dbObject);
        if (arrayList != null) {
            for (DbObject dbObject2 : arrayList) {
                if (dbObject2.getCreateSQL() == null) continue;
                this.updateMeta(session, dbObject2);
            }
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject dbObject, String string) {
        this.checkWritingAllowed();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(dbObject.getName())) {
                DbException.throwInternalError("not found: " + dbObject.getName());
            }
            if (dbObject.getName().equals(string) || hashMap.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        dbObject.checkRename();
        hashMap.remove(dbObject.getName());
        dbObject.rename(string);
        hashMap.put(string, dbObject);
        this.updateMetaAndFirstLevelChildren(session, dbObject);
    }

    public String createTempFile() {
        try {
            boolean bl = this.readOnly;
            String string = this.databaseName;
            if (!this.persistent) {
                string = "memFS:" + string;
            }
            return FileUtils.createTempFile(string, ".temp.db", bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.databaseName);
        }
    }

    private void deleteOldTempFiles() {
        String string = FileUtils.getParent(this.databaseName);
        for (String string2 : FileUtils.newDirectoryStream(string)) {
            if (!string2.endsWith(".temp.db") || !string2.startsWith(this.databaseName)) continue;
            FileUtils.tryDelete(string2);
        }
    }

    public Schema getSchema(String string) {
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject dbObject) {
        this.checkWritingAllowed();
        String string = dbObject.getName();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            DbException.throwInternalError("not found: " + string);
        }
        Comment comment = this.findComment(dbObject);
        this.lockMeta(session);
        if (comment != null) {
            this.removeDatabaseObject(session, comment);
        }
        int n2 = dbObject.getId();
        dbObject.removeChildrenAndResources(session);
        hashMap.remove(string);
        this.removeMeta(session, n2);
    }

    public Table getDependentTable(SchemaObject schemaObject, Table table) {
        switch (schemaObject.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        for (Table table2 : this.getAllTablesAndViews(false)) {
            if (table == table2 || TableType.VIEW == table2.getTableType()) continue;
            hashSet.clear();
            table2.addDependencies(hashSet);
            if (!hashSet.contains(schemaObject)) continue;
            return table2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(Session session, SchemaObject schemaObject) {
        DbObjectBase dbObjectBase;
        Object object;
        int n = schemaObject.getType();
        if (n == 0) {
            object = (Table)schemaObject;
            if (((DbObjectBase)object).isTemporary() && !((Table)object).isGlobalTemporary()) {
                session.removeLocalTempTable((Table)object);
                return;
            }
        } else if (n == 1) {
            object = (Index)schemaObject;
            dbObjectBase = object.getTable();
            if (dbObjectBase.isTemporary() && !dbObjectBase.isGlobalTemporary()) {
                session.removeLocalTempTableIndex((Index)object);
                return;
            }
        } else if (n == 5 && (dbObjectBase = ((Constraint)(object = (Constraint)schemaObject)).getTable()).isTemporary() && !dbObjectBase.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint((Constraint)object);
            return;
        }
        this.checkWritingAllowed();
        this.lockMeta(session);
        object = this;
        synchronized (object) {
            dbObjectBase = this.findComment(schemaObject);
            if (dbObjectBase != null) {
                this.removeDatabaseObject(session, dbObjectBase);
            }
            schemaObject.getSchema().remove(schemaObject);
            int n2 = schemaObject.getId();
            if (!this.starting) {
                Table table = this.getDependentTable(schemaObject, null);
                if (table != null) {
                    schemaObject.getSchema().add(schemaObject);
                    throw DbException.get(90107, schemaObject.getSQL(false), table.getSQL(false));
                }
                schemaObject.removeChildrenAndResources(session);
            }
            this.removeMeta(session, n2);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public synchronized void setCacheSize(int n) {
        if (this.starting) {
            int n2 = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            n = Math.min(n, n2);
        }
        this.cacheSize = n;
        if (this.pageStore != null) {
            this.pageStore.setMaxCacheMemory(n);
        }
        if (this.store != null) {
            this.store.setCacheSize(Math.max(1, n));
        }
    }

    public synchronized void setMasterUser(User user) {
        this.lockMeta(this.systemSession);
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public synchronized String getTempTableName(String string, Session session) {
        String string2;
        while (this.mainSchema.findTableOrView(session, string2 = string + "_COPY_" + session.getId() + "_" + this.nextTempTableId++) != null) {
        }
        return string2;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    @Override
    public void checkWritingAllowed() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
        if (this.fileLockMethod == FileLockMethod.SERIALIZED && !this.reconnectChangePending) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.writer != null) {
            this.writer.setWriteDelay(n);
            boolean bl = this.flushOnEachCommit = this.writeDelay < 5;
        }
        if (this.store != null) {
            int n2 = n < 0 ? 0 : n;
            this.store.getMvStore().setAutoCommitDelay(n2);
        }
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
        if (this.store != null) {
            this.store.getMvStore().setRetentionTime(n);
        }
    }

    public void setAllowBuiltinAliasOverride(boolean bl) {
        this.allowBuiltinAliasOverride = bl;
    }

    public boolean isAllowBuiltinAliasOverride() {
        return this.allowBuiltinAliasOverride;
    }

    public boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        if (this.store != null) {
            return this.store.getInDoubtTransactions();
        }
        return this.pageStore == null ? null : this.pageStore.getInDoubtTransactions();
    }

    synchronized void prepareCommit(Session session, String string) {
        if (this.readOnly) {
            return;
        }
        if (this.store != null) {
            this.store.prepareCommit(session, string);
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.flushLog();
            this.pageStore.prepareCommit(session, string);
        }
    }

    synchronized void commit(Session session) {
        this.throwLastBackgroundException();
        if (this.readOnly) {
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.commit(session);
        }
        session.setAllCommitted();
    }

    private void throwLastBackgroundException() {
        DbException dbException = this.backgroundException.getAndSet(null);
        if (dbException != null) {
            throw DbException.get(dbException.getErrorCode(), dbException, dbException.getMessage());
        }
    }

    public void setBackgroundException(DbException dbException) {
        TraceSystem traceSystem;
        if (this.backgroundException.compareAndSet(null, dbException) && (traceSystem = this.getTraceSystem()) != null) {
            traceSystem.getTrace(2).error(dbException, "flush");
        }
    }

    public Throwable getBackgroundException() {
        IllegalStateException illegalStateException = this.store.getMvStore().getPanicException();
        if (illegalStateException != null) {
            return illegalStateException;
        }
        return this.backgroundException.getAndSet(null);
    }

    public synchronized void flush() {
        if (this.readOnly) {
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.flushLog();
        }
        if (this.store != null) {
            try {
                this.store.flush();
            }
            catch (RuntimeException runtimeException) {
                this.backgroundException.compareAndSet(null, DbException.convert(runtimeException));
                throw runtimeException;
            }
        }
    }

    public void setEventListener(DatabaseEventListener databaseEventListener) {
        this.eventListener = databaseEventListener;
    }

    public void setEventListenerClass(String string) {
        if (string == null || string.isEmpty()) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)JdbcUtils.loadUserClass(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String string2 = this.databaseURL;
                if (this.cipher != null) {
                    string2 = string2 + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(string2);
            }
            catch (Throwable throwable) {
                throw DbException.get(90099, throwable, string, throwable.toString());
            }
        }
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(n, string, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(sQLException, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void sync() {
        if (this.readOnly) {
            return;
        }
        if (this.store != null) {
            this.store.sync();
        }
        if (this.pageStore != null) {
            this.pageStore.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    public void setMaxMemoryUndo(int n) {
        this.maxMemoryUndo = n;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int n) {
        switch (n) {
            case 0: {
                if (!this.multiThreaded || this.isMVStore()) break;
                throw DbException.get(90021, "MV_STORE=FALSE & LOCK_MODE=0 & MULTI_THREADED=TRUE");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", n);
            }
        }
        this.lockMode = n;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public void setCloseDelay(int n) {
        this.closeDelay = n;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int n) {
        this.maxLengthInplaceLob = n;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.maxLengthInplaceLob;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean bl) {
        this.deleteFilesOnDisconnect = bl;
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String string) {
        this.lobCompressionAlgorithm = string;
    }

    public synchronized void setMaxLogSize(long l) {
        if (this.pageStore != null) {
            this.pageStore.setMaxLogSize(l);
        }
    }

    public void setAllowLiterals(int n) {
        this.allowLiterals = n;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean bl) {
        this.optimizeReuseResults = bl;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean bl) {
        this.referentialIntegrity = bl;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryStatistics(boolean bl) {
        this.queryStatistics = bl;
        Database database = this;
        synchronized (database) {
            if (!bl) {
                this.queryStatisticsData = null;
            }
        }
    }

    public boolean getQueryStatistics() {
        return this.queryStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryStatisticsMaxEntries(int n) {
        this.queryStatisticsMaxEntries = n;
        if (this.queryStatisticsData != null) {
            Database database = this;
            synchronized (database) {
                if (this.queryStatisticsData != null) {
                    this.queryStatisticsData.setMaxQueryEntries(this.queryStatisticsMaxEntries);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStatisticsData getQueryStatisticsData() {
        if (!this.queryStatistics) {
            return null;
        }
        if (this.queryStatisticsData == null) {
            Database database = this;
            synchronized (database) {
                if (this.queryStatisticsData == null) {
                    this.queryStatisticsData = new QueryStatisticsData(this.queryStatisticsMaxEntries);
                }
            }
        }
        return this.queryStatisticsData;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMVStore() {
        return this.dbSettings.mvStore;
    }

    void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
        if (this.writer != null) {
            this.writer.startThread();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean bl) {
        if (bl && this.multiThreaded != bl && this.lockMode == 0 && !this.isMVStore()) {
            throw DbException.get(90021, "MV_STORE=FALSE & LOCK_MODE=0 & MULTI_THREADED=TRUE");
        }
        this.multiThreaded = bl;
    }

    public void setMaxOperationMemory(int n) {
        this.maxOperationMemory = n;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession.get();
    }

    public void setExclusiveSession(Session session, boolean bl) {
        this.exclusiveSession.set(session);
        if (bl) {
            this.closeAllSessionsException(session);
        }
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        if (this.lobFileListCache == null) {
            this.lobFileListCache = SmallLRUCache.newInstance(128);
        }
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta == null || this.meta.isLockedExclusively();
    }

    public boolean isSysTableLockedBy(Session session) {
        return this.meta == null || this.meta.isLockedExclusivelyBy(session);
    }

    public TableLinkConnection getLinkConnection(String string, String string2, String string3, String string4) {
        if (this.linkConnections == null) {
            this.linkConnections = new HashMap();
        }
        return TableLinkConnection.open(this.linkConnections, string, string2, string3, string4, this.dbSettings.shareLinkedConnections);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.closing = true;
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.closeFiles();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageStore getPageStore() {
        if (this.dbSettings.mvStore) {
            if (this.store == null) {
                this.store = MVTableEngine.init(this);
            }
            return null;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore == null) {
                this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, this.cacheSize);
                if (this.pageSize != 4096) {
                    this.pageStore.setPageSize(this.pageSize);
                }
                if (!this.readOnly && this.fileLockMethod == FileLockMethod.FS) {
                    this.pageStore.setLockFile(true);
                }
                this.pageStore.setLogMode(this.logMode);
                this.pageStore.open();
            }
            return this.pageStore;
        }
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews(false)) {
            if (table.getCreateSQL() == null || table.isHidden() || table.getSchema().getId() == -1 && table.getName().equalsIgnoreCase("LOB_BLOCKS")) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return false;
        }
        if (this.reconnectChangePending) {
            return false;
        }
        long l = System.nanoTime();
        if (l < this.reconnectCheckNext) {
            return false;
        }
        this.reconnectCheckNext = l + this.reconnectCheckDelayNs;
        if (this.lock == null) {
            this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
        }
        try {
            Properties properties;
            Properties properties2 = properties = this.lock.load();
            while (true) {
                if (properties.equals(this.reconnectLastLock)) {
                    return false;
                }
                if (properties.getProperty("changePending", null) == null) break;
                if (System.nanoTime() > l + this.reconnectCheckDelayNs * 10L && properties2.equals(properties)) {
                    this.lock.setProperty("changePending", null);
                    this.lock.save();
                    break;
                }
                this.trace.debug("delay (change pending)");
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.reconnectCheckDelayNs));
                properties = this.lock.load();
            }
            this.reconnectLastLock = properties;
        }
        catch (Exception exception) {
            this.trace.error(exception, "readOnly {0}", this.readOnly);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED || this.readOnly || !this.reconnectChangePending || this.closing) {
            return;
        }
        long l = System.nanoTime();
        if (l > this.reconnectCheckNext + this.reconnectCheckDelayNs) {
            if (this.checkpointAllowed < 0) {
                DbException.throwInternalError(Integer.toString(this.checkpointAllowed));
            }
            Object object = this.reconnectSync;
            synchronized (object) {
                if (this.checkpointAllowed > 0) {
                    return;
                }
                this.checkpointRunning = true;
            }
            object = this;
            synchronized (object) {
                this.trace.debug("checkpoint start");
                this.flushSequences();
                this.checkpoint();
                this.reconnectModified(false);
                this.trace.debug("checkpoint end");
            }
            object = this.reconnectSync;
            synchronized (object) {
                this.checkpointRunning = false;
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fileLockMethod == FileLockMethod.SERIALIZED;
    }

    private void flushSequences() {
        for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
            Sequence sequence = (Sequence)schemaObject;
            sequence.flushWithoutMargin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.persistent) {
            Database database = this;
            synchronized (database) {
                if (this.pageStore != null) {
                    this.pageStore.checkpoint();
                }
            }
            if (this.store != null) {
                this.store.flush();
            }
        }
        this.getTempFileDeleter().deleteUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeWriting() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return true;
        }
        while (this.checkpointRunning) {
            try {
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            catch (Exception exception) {}
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            if (this.reconnectModified(true)) {
                if (++this.checkpointAllowed > 20) {
                    throw DbException.throwInternalError(Integer.toString(this.checkpointAllowed));
                }
                return true;
            }
        }
        this.reconnectCheckNext = System.nanoTime() - 1L;
        this.reconnectLastLock = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWriting() {
        if (this.fileLockMethod != FileLockMethod.SERIALIZED) {
            return;
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            --this.checkpointAllowed;
        }
        if (this.checkpointAllowed < 0) {
            throw DbException.throwInternalError(Integer.toString(this.checkpointAllowed));
        }
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setCompactMode(int n) {
        this.compactMode = n;
    }

    public SourceCompiler getCompiler() {
        if (this.compiler == null) {
            this.compiler = new SourceCompiler();
        }
        return this.compiler;
    }

    @Override
    public LobStorageInterface getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = this.dbSettings.mvStore ? new LobStorageMap(this) : new LobStorageBackend(this);
        }
        return this.lobStorage;
    }

    public JdbcConnection getLobConnectionForInit() {
        String string = "jdbc:default:connection";
        JdbcConnection jdbcConnection = new JdbcConnection(this.systemSession, this.systemUser.getName(), string);
        jdbcConnection.setTraceLevel(0);
        return jdbcConnection;
    }

    public JdbcConnection getLobConnectionForRegularUse() {
        String string = "jdbc:default:connection";
        JdbcConnection jdbcConnection = new JdbcConnection(this.lobSession, this.systemUser.getName(), string);
        jdbcConnection.setTraceLevel(0);
        return jdbcConnection;
    }

    public Session getLobSession() {
        return this.lobSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogMode(int n) {
        if (n < 0 || n > 2) {
            throw DbException.getInvalidValueException("LOG", n);
        }
        if (this.store != null) {
            this.logMode = n;
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore != null) {
                if (n != 2 || this.pageStore.getLogMode() != 2) {
                    this.trace.error(null, "log {0}", n);
                }
                this.logMode = n;
                this.pageStore.setLogMode(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogMode() {
        if (this.store != null) {
            return this.logMode;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore != null) {
                return this.pageStore.getLogMode();
            }
        }
        return 0;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void setDefaultTableType(int n) {
        this.defaultTableType = n;
    }

    public DbSettings getSettings() {
        return this.dbSettings;
    }

    public <V> HashMap<String, V> newStringMap() {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveMap() : new HashMap();
    }

    public <V> ConcurrentHashMap<String, V> newConcurrentStringMap() {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveConcurrentMap() : new ConcurrentHashMap();
    }

    public boolean equalsIdentifiers(String string, String string2) {
        return string.equals(string2) || this.dbSettings.caseInsensitiveIdentifiers && string.equalsIgnoreCase(string2);
    }

    public String sysIdentifier(String string) {
        assert (Database.isUpperSysIdentifier(string));
        return this.dbSettings.databaseToLower ? StringUtils.toLowerEnglish(string) : string;
    }

    private static boolean isUpperSysIdentifier(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && (c <= 'Z' || c == '_')) continue;
            return false;
        }
        return true;
    }

    @Override
    public int readLob(long l, byte[] byArray, long l2, byte[] byArray2, int n, int n2) {
        throw DbException.throwInternalError();
    }

    public byte[] getFileEncryptionKey() {
        return this.fileEncryptionKey;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        this.initJavaObjectSerializer();
        return this.javaObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJavaObjectSerializer() {
        if (this.javaObjectSerializerInitialized) {
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.javaObjectSerializerInitialized) {
                return;
            }
            String string = this.javaObjectSerializerName;
            if (string != null && !(string = string.trim()).isEmpty() && !string.equals("null")) {
                try {
                    this.javaObjectSerializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            this.javaObjectSerializerInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaObjectSerializerName(String string) {
        Database database = this;
        synchronized (database) {
            this.javaObjectSerializerInitialized = false;
            this.javaObjectSerializerName = string;
        }
    }

    public TableEngine getTableEngine(String string) {
        assert (Thread.holdsLock(this));
        TableEngine tableEngine = this.tableEngines.get(string);
        if (tableEngine == null) {
            try {
                tableEngine = (TableEngine)JdbcUtils.loadUserClass(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
            this.tableEngines.put(string, tableEngine);
        }
        return tableEngine;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (authenticator != null) {
            authenticator.init(this);
        }
        this.authenticator = authenticator;
    }

    static {
        EMPTY_SESSION_ARRAY = new Session[0];
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT = bl;
        if (bl) {
            META_LOCK_DEBUGGING = new ThreadLocal();
            META_LOCK_DEBUGGING_DB = new ThreadLocal();
            META_LOCK_DEBUGGING_STACK = new ThreadLocal();
        } else {
            META_LOCK_DEBUGGING = null;
            META_LOCK_DEBUGGING_DB = null;
            META_LOCK_DEBUGGING_STACK = null;
        }
    }
}

