/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.protocol;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.SshClient;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorizationProvider;
import org.opendaylight.netconf.callhome.protocol.CallHomeNetconfSubsystemListener;
import org.opendaylight.netconf.callhome.protocol.CallHomeSessionContext;
import org.opendaylight.netconf.callhome.protocol.NetconfCallHomeServer;
import org.opendaylight.netconf.callhome.protocol.StatusRecorder;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.yangtools.concepts.Builder;

public class NetconfCallHomeServerBuilder
implements Builder<NetconfCallHomeServer> {
    private static final long DEFAULT_SESSION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final int DEFAULT_CALL_HOME_PORT = 6666;
    private SshClient sshClient;
    private EventLoopGroup nettyGroup;
    private NetconfClientSessionNegotiatorFactory negotiationFactory;
    private InetSocketAddress bindAddress;
    private final CallHomeAuthorizationProvider authProvider;
    private final CallHomeNetconfSubsystemListener subsystemListener;
    private final StatusRecorder recorder;

    public NetconfCallHomeServerBuilder(CallHomeAuthorizationProvider authProvider, CallHomeNetconfSubsystemListener subsystemListener, StatusRecorder recorder) {
        this.authProvider = authProvider;
        this.subsystemListener = subsystemListener;
        this.recorder = recorder;
    }

    public NetconfCallHomeServer build() {
        CallHomeSessionContext.Factory factory = new CallHomeSessionContext.Factory(this.nettyGroup(), this.negotiatorFactory(), this.subsystemListener());
        return new NetconfCallHomeServer(this.sshClient(), this.authProvider(), factory, this.bindAddress(), this.recorder);
    }

    public SshClient getSshClient() {
        return this.sshClient;
    }

    public void setSshClient(SshClient sshClient) {
        this.sshClient = sshClient;
    }

    public EventLoopGroup getNettyGroup() {
        return this.nettyGroup;
    }

    public void setNettyGroup(EventLoopGroup nettyGroup) {
        this.nettyGroup = nettyGroup;
    }

    public NetconfClientSessionNegotiatorFactory getNegotiationFactory() {
        return this.negotiationFactory;
    }

    public void setNegotiationFactory(NetconfClientSessionNegotiatorFactory negotiationFactory) {
        this.negotiationFactory = negotiationFactory;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public CallHomeAuthorizationProvider getAuthProvider() {
        return this.authProvider;
    }

    private InetSocketAddress bindAddress() {
        return this.bindAddress != null ? this.bindAddress : NetconfCallHomeServerBuilder.defaultBindAddress();
    }

    private EventLoopGroup nettyGroup() {
        return this.nettyGroup != null ? this.nettyGroup : NetconfCallHomeServerBuilder.defaultNettyGroup();
    }

    private NetconfClientSessionNegotiatorFactory negotiatorFactory() {
        return this.negotiationFactory != null ? this.negotiationFactory : NetconfCallHomeServerBuilder.defaultNegotiationFactory();
    }

    private CallHomeNetconfSubsystemListener subsystemListener() {
        return this.subsystemListener;
    }

    private CallHomeAuthorizationProvider authProvider() {
        return this.authProvider;
    }

    private SshClient sshClient() {
        return this.sshClient != null ? this.sshClient : NetconfCallHomeServerBuilder.defaultSshClient();
    }

    private static SshClient defaultSshClient() {
        return SshClient.setUpDefaultClient();
    }

    private static NetconfClientSessionNegotiatorFactory defaultNegotiationFactory() {
        return new NetconfClientSessionNegotiatorFactory((Timer)new HashedWheelTimer(), Optional.empty(), DEFAULT_SESSION_TIMEOUT_MILLIS);
    }

    private static EventLoopGroup defaultNettyGroup() {
        return new DefaultEventLoopGroup();
    }

    private static InetSocketAddress defaultBindAddress() {
        return new InetSocketAddress(6666);
    }
}

