/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.undertow.openwebbeans.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.util.Asserts;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleSingletonService
implements SingletonService<WebBeansContext> {
    private static Logger log = LoggerFactory.getLogger(BundleSingletonService.class);
    private final Map<Long, WebBeansContext> singletonMap = new HashMap<Long, WebBeansContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBeansContext get(Object key) {
        Bundle bundle = this.toBundle(key);
        long bundleId = bundle.getBundleId();
        Map<Long, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            WebBeansContext webBeansContext = this.singletonMap.get(bundleId);
            if (webBeansContext == null) {
                Properties props = new Properties();
                HashMap initialServices = new HashMap();
                String resource = "/META-INF/openwebbeans/standalone.properties";
                if (bundle.getHeaders().get("Web-ContextPath") != null) {
                    resource = "/META-INF/openwebbeans/wab.properties";
                }
                try {
                    props.load(this.getClass().getResourceAsStream(resource));
                }
                catch (IOException exc) {
                    throw Exceptions.unchecked((Throwable)exc);
                }
                webBeansContext = new WebBeansContext(initialServices, props);
                this.singletonMap.put(bundleId, webBeansContext);
            }
            return webBeansContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInstances(ClassLoader classLoader) {
        Asserts.assertNotNull((Object)classLoader, (String)"classloader is null");
        Bundle bundle = this.toBundle(classLoader);
        Map<Long, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            this.singletonMap.remove(bundle.getBundleId());
        }
    }

    public void clear(Object classLoader) {
        this.clearInstances((ClassLoader)classLoader);
    }

    private Bundle toBundle(Object key) {
        BundleClassLoader bcl;
        if (key instanceof BundleClassLoader && (bcl = (BundleClassLoader)key).getParent() instanceof BundleReference) {
            return ((BundleReference)BundleReference.class.cast(bcl.getParent())).getBundle();
        }
        if (key instanceof BundleReference) {
            return ((BundleReference)BundleReference.class.cast(key)).getBundle();
        }
        log.error("classloader {} does not implement BundleReference", key);
        return null;
    }
}

