/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.util.LazyCollections;

abstract class AbstractTypeMemberBuilder<T extends TypeMemberBuilder<T>>
implements TypeMemberBuilder<T> {
    private final String name;
    private Type returnType;
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private String comment = "";
    private boolean isFinal;
    private boolean isStatic;
    private AccessModifier accessModifier;

    AbstractTypeMemberBuilder(String name) {
        this.name = name;
    }

    public AnnotationTypeBuilder addAnnotation(JavaTypeName identifier) {
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(identifier);
        this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
        return builder;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    protected Iterable<AnnotationTypeBuilder> getAnnotationBuilders() {
        return this.annotationBuilders;
    }

    protected String getComment() {
        return this.comment;
    }

    protected boolean isFinal() {
        return this.isFinal;
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public String getName() {
        return this.name;
    }

    protected abstract T thisInstance();

    public T setReturnType(Type newReturnType) {
        Preconditions.checkArgument((newReturnType != null ? 1 : 0) != 0, (Object)"Return Type of member cannot be null!");
        this.returnType = newReturnType;
        return this.thisInstance();
    }

    public T setAccessModifier(AccessModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"Access Modifier for member type cannot be null!");
        this.accessModifier = modifier;
        return this.thisInstance();
    }

    public T setComment(String newComment) {
        this.comment = newComment;
        return this.thisInstance();
    }

    public T setFinal(boolean newIsFinal) {
        this.isFinal = newIsFinal;
        return this.thisInstance();
    }

    public T setStatic(boolean newIsStatic) {
        this.isStatic = newIsStatic;
        return this.thisInstance();
    }

    protected List<AnnotationType> toAnnotationTypes() {
        ArrayList<AnnotationType> annotations = new ArrayList<AnnotationType>();
        for (AnnotationTypeBuilder annotBuilder : this.getAnnotationBuilders()) {
            if (annotBuilder == null) continue;
            annotations.add(annotBuilder.build());
        }
        return ImmutableList.copyOf(annotations);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.getReturnType());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTypeMemberBuilder other = (AbstractTypeMemberBuilder)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getReturnType(), other.getReturnType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedPropertyImpl [name=");
        builder.append(this.getName());
        builder.append(", annotations=");
        builder.append(this.getAnnotationBuilders());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", isFinal=");
        builder.append(this.isFinal());
        builder.append(", modifier=");
        builder.append(this.getAccessModifier());
        builder.append("]");
        return builder.toString();
    }
}

