/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractGeneratedType;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractGeneratedTypeBuilder;
import org.opendaylight.yangtools.util.LazyCollections;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

abstract class AbstractGeneratedTOBuilder
extends AbstractGeneratedTypeBuilder<GeneratedTOBuilder>
implements GeneratedTOBuilder {
    private List<GeneratedPropertyBuilder> equalsProperties = Collections.emptyList();
    private List<GeneratedPropertyBuilder> hashProperties = Collections.emptyList();
    private List<GeneratedPropertyBuilder> toStringProperties = Collections.emptyList();
    private GeneratedTransferObject extendsType;
    private boolean isTypedef = false;
    private boolean isUnionType = false;
    private boolean isUnionTypeBuilder = false;
    private TypeDefinition<?> baseType = null;

    AbstractGeneratedTOBuilder(JavaTypeName identifier) {
        super(identifier);
        this.setAbstract(false);
    }

    public final GeneratedTOBuilder setExtendsType(GeneratedTransferObject genTransObj) {
        Preconditions.checkArgument((genTransObj != null ? 1 : 0) != 0, (Object)"Generated Transfer Object cannot be null!");
        this.extendsType = genTransObj;
        return this;
    }

    @Override
    public final MethodSignatureBuilder addMethod(String name) {
        MethodSignatureBuilder builder = super.addMethod(name);
        builder.setAbstract(false);
        return builder;
    }

    public final GeneratedTOBuilder addEqualsIdentity(GeneratedPropertyBuilder property) {
        this.equalsProperties = LazyCollections.lazyAdd(this.equalsProperties, (Object)property);
        return this;
    }

    public final GeneratedTOBuilder addHashIdentity(GeneratedPropertyBuilder property) {
        this.hashProperties = LazyCollections.lazyAdd(this.hashProperties, (Object)property);
        return this;
    }

    public final GeneratedTOBuilder addToStringProperty(GeneratedPropertyBuilder property) {
        this.toStringProperties = LazyCollections.lazyAdd(this.toStringProperties, (Object)property);
        return this;
    }

    @Override
    protected final GeneratedTOBuilder thisInstance() {
        return this;
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedTransferObject [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", constants=");
        builder.append(this.getConstants());
        builder.append(", enumerations=");
        builder.append(this.getEnumerations());
        builder.append(", equalsProperties=");
        builder.append(this.equalsProperties);
        builder.append(", hashCodeProperties=");
        builder.append(this.hashProperties);
        builder.append(", stringProperties=");
        builder.append(this.toStringProperties);
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append(", methods=");
        builder.append(this.getMethodDefinitions());
        builder.append("]");
        return builder.toString();
    }

    public final void setTypedef(boolean newIsTypedef) {
        this.isTypedef = newIsTypedef;
    }

    public final void setBaseType(TypeDefinition<?> typeDef) {
        this.baseType = typeDef;
    }

    public final void setIsUnion(boolean newIsUnion) {
        this.isUnionType = newIsUnion;
    }

    public final boolean isUnion() {
        return this.isUnionType;
    }

    public final void setIsUnionBuilder(boolean newIsUnionTypeBuilder) {
        this.isUnionTypeBuilder = newIsUnionTypeBuilder;
    }

    static abstract class AbstractGeneratedTransferObject
    extends AbstractGeneratedType
    implements GeneratedTransferObject {
        private final List<GeneratedProperty> equalsProperties;
        private final List<GeneratedProperty> hashCodeProperties;
        private final List<GeneratedProperty> stringProperties;
        private final GeneratedTransferObject extendsType;
        private final boolean isTypedef;
        private final TypeDefinition<?> baseType;
        private final boolean isUnionType;
        private final boolean isUnionTypeBuilder;

        AbstractGeneratedTransferObject(AbstractGeneratedTOBuilder builder) {
            super(builder);
            this.extendsType = builder.extendsType;
            this.equalsProperties = this.toUnmodifiableProperties(builder.equalsProperties);
            this.hashCodeProperties = this.toUnmodifiableProperties(builder.hashProperties);
            this.stringProperties = this.toUnmodifiableProperties(builder.toStringProperties);
            this.isTypedef = builder.isTypedef;
            this.baseType = builder.baseType;
            this.isUnionType = builder.isUnionType;
            this.isUnionTypeBuilder = builder.isUnionTypeBuilder;
        }

        public final boolean isTypedef() {
            return this.isTypedef;
        }

        public final TypeDefinition<?> getBaseType() {
            return this.baseType;
        }

        public final boolean isUnionType() {
            return this.isUnionType;
        }

        public final boolean isUnionTypeBuilder() {
            return this.isUnionTypeBuilder;
        }

        public final GeneratedTransferObject getSuperType() {
            return this.extendsType;
        }

        public final List<GeneratedProperty> getEqualsIdentifiers() {
            return this.equalsProperties;
        }

        public final List<GeneratedProperty> getHashCodeIdentifiers() {
            return this.hashCodeProperties;
        }

        public final List<GeneratedProperty> getToStringIdentifiers() {
            return this.stringProperties;
        }

        @Override
        public final String toString() {
            if (this.isTypedef) {
                return this.serializeTypedef(this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("GeneratedTransferObject [packageName=");
            builder.append(this.getPackageName());
            builder.append(", name=");
            builder.append(this.getName());
            builder.append(", comment=");
            builder.append(", annotations=");
            builder.append(this.getAnnotations());
            builder.append(this.getComment());
            builder.append(", extends=");
            builder.append(this.getSuperType());
            builder.append(", implements=");
            builder.append(this.getImplements());
            builder.append(", enclosedTypes=");
            builder.append(this.getEnclosedTypes());
            builder.append(", constants=");
            builder.append(this.getConstantDefinitions());
            builder.append(", enumerations=");
            builder.append(this.getEnumerations());
            builder.append(", properties=");
            builder.append(this.getProperties());
            builder.append(", equalsProperties=");
            builder.append(this.equalsProperties);
            builder.append(", hashCodeProperties=");
            builder.append(this.hashCodeProperties);
            builder.append(", stringProperties=");
            builder.append(this.stringProperties);
            builder.append(", methods=");
            builder.append(this.getMethodDefinitions());
            builder.append("]");
            return builder.toString();
        }

        public final String serializeTypedef(Type type) {
            if (!(type instanceof ParameterizedType)) {
                return type.getFullyQualifiedName();
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            sb.append(parameterizedType.getRawType().getFullyQualifiedName()).append('<');
            boolean first = true;
            for (Type parameter : parameterizedType.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(this.serializeTypedef(parameter));
            }
            return sb.append('>').toString();
        }
    }
}

