/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util;

import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedListAction;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.common.RpcResult;

public final class BindingTypes {
    public static final ConcreteType BASE_IDENTITY = Types.typeForClass(BaseIdentity.class);
    public static final ConcreteType DATA_CONTAINER = Types.typeForClass(DataContainer.class);
    public static final ConcreteType DATA_OBJECT = Types.typeForClass(DataObject.class);
    public static final ConcreteType TYPE_OBJECT = Types.typeForClass(TypeObject.class);
    public static final ConcreteType DATA_ROOT = Types.typeForClass(DataRoot.class);
    public static final ConcreteType NOTIFICATION = Types.typeForClass(Notification.class);
    public static final ConcreteType NOTIFICATION_LISTENER = Types.typeForClass(NotificationListener.class);
    public static final ConcreteType RPC_INPUT = Types.typeForClass(RpcInput.class);
    public static final ConcreteType RPC_OUTPUT = Types.typeForClass(RpcOutput.class);
    public static final ConcreteType RPC_SERVICE = Types.typeForClass(RpcService.class);
    public static final JavaTypeName ROUTING_CONTEXT = JavaTypeName.create(RoutingContext.class);
    @VisibleForTesting
    static final ConcreteType AUGMENTABLE = Types.typeForClass(Augmentable.class);
    @VisibleForTesting
    static final ConcreteType AUGMENTATION = Types.typeForClass(Augmentation.class);
    @VisibleForTesting
    static final ConcreteType IDENTIFIABLE = Types.typeForClass(Identifiable.class);
    @VisibleForTesting
    static final ConcreteType IDENTIFIER = Types.typeForClass(Identifier.class);
    @VisibleForTesting
    static final ConcreteType INSTANCE_IDENTIFIER = Types.typeForClass(InstanceIdentifier.class);
    private static final ConcreteType ACTION = Types.typeForClass(Action.class);
    private static final ConcreteType CHILD_OF = Types.typeForClass(ChildOf.class);
    private static final ConcreteType CHOICE_IN = Types.typeForClass(ChoiceIn.class);
    private static final ConcreteType KEYED_LIST_ACTION = Types.typeForClass(KeyedListAction.class);
    private static final ConcreteType RPC_RESULT = Types.typeForClass(RpcResult.class);

    private BindingTypes() {
    }

    public static ParameterizedType action(Type parent, Type input, Type output) {
        return Types.parameterizedTypeFor((Type)ACTION, new Type[]{BindingTypes.instanceIdentifier(parent), input, output});
    }

    public static ParameterizedType keyedListAction(Type parent, Type keyType, Type input, Type output) {
        return Types.parameterizedTypeFor((Type)KEYED_LIST_ACTION, keyType, parent, input, output);
    }

    public static ParameterizedType augmentable(Type type) {
        return Types.parameterizedTypeFor((Type)AUGMENTABLE, type);
    }

    public static ParameterizedType childOf(Type type) {
        return Types.parameterizedTypeFor((Type)CHILD_OF, type);
    }

    public static ParameterizedType choiceIn(Type type) {
        return Types.parameterizedTypeFor((Type)CHOICE_IN, type);
    }

    public static ParameterizedType identifier(Type type) {
        return Types.parameterizedTypeFor((Type)IDENTIFIER, type);
    }

    public static ParameterizedType identifiable(Type type) {
        return Types.parameterizedTypeFor((Type)IDENTIFIABLE, type);
    }

    public static ParameterizedType instanceIdentifier(Type type) {
        return Types.parameterizedTypeFor((Type)INSTANCE_IDENTIFIER, type);
    }

    public static ParameterizedType rpcResult(Type type) {
        return Types.parameterizedTypeFor((Type)RPC_RESULT, type);
    }
}

