/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.ProtonException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.ByteBufferDecoder;
import org.apache.qpid.proton.codec.ByteType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.DoubleType;
import org.apache.qpid.proton.codec.DynamicTypeConstructor;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.FloatType;
import org.apache.qpid.proton.codec.IntegerType;
import org.apache.qpid.proton.codec.LongType;
import org.apache.qpid.proton.codec.PrimitiveType;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ShortType;
import org.apache.qpid.proton.codec.TypeConstructor;

public class DecoderImpl
implements ByteBufferDecoder {
    private ByteBuffer _buffer;
    private final CharsetDecoder _charsetDecoder = StandardCharsets.UTF_8.newDecoder();
    private final PrimitiveTypeEncoding[] _constructors = new PrimitiveTypeEncoding[256];
    private final Map<Object, DescribedTypeConstructor> _dynamicTypeConstructors = new HashMap<Object, DescribedTypeConstructor>();
    private final Map<Object, FastPathDescribedTypeConstructor<?>> _fastPathTypeConstructors = new HashMap();

    public DecoderImpl() {
    }

    DecoderImpl(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConstructor<?> peekConstructor() {
        this._buffer.mark();
        try {
            TypeConstructor typeConstructor = this.readConstructor();
            return typeConstructor;
        }
        finally {
            this._buffer.reset();
        }
    }

    public TypeConstructor readConstructor() {
        return this.readConstructor(false);
    }

    public TypeConstructor readConstructor(boolean excludeFastPathConstructors) {
        int code = this.readRawByte() & 0xFF;
        if (code == 0) {
            TypeConstructor fastPathTypeConstructor;
            byte encoding = this._buffer.get(this._buffer.position());
            final Object descriptor = 83 == encoding || -128 == encoding ? this.readUnsignedLong() : (-93 == encoding || -77 == encoding ? this.readSymbol() : this.readObject());
            if (!excludeFastPathConstructors && (fastPathTypeConstructor = (TypeConstructor)this._fastPathTypeConstructors.get(descriptor)) != null) {
                return fastPathTypeConstructor;
            }
            TypeConstructor nestedEncoding = this.readConstructor();
            DescribedTypeConstructor dtc = this._dynamicTypeConstructors.get(descriptor);
            if (dtc == null) {
                dtc = new DescribedTypeConstructor(){

                    public DescribedType newInstance(Object described) {
                        return new UnknownDescribedType(descriptor, described);
                    }

                    @Override
                    public Class<?> getTypeClass() {
                        return UnknownDescribedType.class;
                    }
                };
                this.register(descriptor, dtc);
            }
            return new DynamicTypeConstructor(dtc, nestedEncoding);
        }
        return this._constructors[code];
    }

    @Override
    public void register(Object descriptor, FastPathDescribedTypeConstructor<?> btc) {
        this._fastPathTypeConstructors.put(descriptor, btc);
    }

    @Override
    public void register(Object descriptor, DescribedTypeConstructor dtc) {
        this._fastPathTypeConstructors.remove(descriptor);
        this._dynamicTypeConstructors.put(descriptor, dtc);
    }

    private ClassCastException unexpectedType(Object val, Class clazz) {
        return new ClassCastException("Unexpected type " + val.getClass().getName() + ". Expected " + clazz.getName() + ".");
    }

    @Override
    public Boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public Boolean readBoolean(Boolean defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 65: {
                return Boolean.TRUE;
            }
            case 66: {
                return Boolean.FALSE;
            }
            case 86: {
                return (Boolean)this._constructors[86].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected boolean type but found encoding: " + encodingCode);
    }

    @Override
    public boolean readBoolean(boolean defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 65: {
                return true;
            }
            case 66: {
                return false;
            }
            case 86: {
                return (Boolean)this._constructors[86].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected boolean type but found encoding: " + encodingCode);
    }

    @Override
    public Byte readByte() {
        return this.readByte(null);
    }

    @Override
    public Byte readByte(Byte defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 81: {
                return (Byte)this._constructors[81].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected byte type but found encoding: " + encodingCode);
    }

    @Override
    public byte readByte(byte defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof ByteType.ByteEncoding) {
            return ((ByteType.ByteEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Byte.class);
    }

    @Override
    public Short readShort() {
        return this.readShort(null);
    }

    @Override
    public Short readShort(Short defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 97: {
                return (Short)this._constructors[97].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected Short type but found encoding: " + encodingCode);
    }

    @Override
    public short readShort(short defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof ShortType.ShortEncoding) {
            return ((ShortType.ShortEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Short.class);
    }

    @Override
    public Integer readInteger() {
        return this.readInteger(null);
    }

    @Override
    public Integer readInteger(Integer defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 84: {
                return (Integer)this._constructors[84].readValue();
            }
            case 113: {
                return (Integer)this._constructors[113].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected Integer type but found encoding: " + encodingCode);
    }

    @Override
    public int readInteger(int defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof IntegerType.IntegerEncoding) {
            return ((IntegerType.IntegerEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Integer.class);
    }

    @Override
    public Long readLong() {
        return this.readLong(null);
    }

    @Override
    public Long readLong(Long defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 85: {
                return (Long)this._constructors[85].readValue();
            }
            case -127: {
                return (Long)this._constructors[129].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected Long type but found encoding: " + encodingCode);
    }

    @Override
    public long readLong(long defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof LongType.LongEncoding) {
            return ((LongType.LongEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Long.class);
    }

    @Override
    public UnsignedByte readUnsignedByte() {
        return this.readUnsignedByte(null);
    }

    @Override
    public UnsignedByte readUnsignedByte(UnsignedByte defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 80: {
                return (UnsignedByte)this._constructors[80].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected unsigned byte type but found encoding: " + encodingCode);
    }

    @Override
    public UnsignedShort readUnsignedShort() {
        return this.readUnsignedShort(null);
    }

    @Override
    public UnsignedShort readUnsignedShort(UnsignedShort defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 96: {
                return (UnsignedShort)this._constructors[96].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected UnsignedShort type but found encoding: " + encodingCode);
    }

    @Override
    public UnsignedInteger readUnsignedInteger() {
        return this.readUnsignedInteger(null);
    }

    @Override
    public UnsignedInteger readUnsignedInteger(UnsignedInteger defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 67: {
                return UnsignedInteger.ZERO;
            }
            case 82: {
                return (UnsignedInteger)this._constructors[82].readValue();
            }
            case 112: {
                return (UnsignedInteger)this._constructors[112].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected UnsignedInteger type but found encoding: " + encodingCode);
    }

    @Override
    public UnsignedLong readUnsignedLong() {
        return this.readUnsignedLong(null);
    }

    @Override
    public UnsignedLong readUnsignedLong(UnsignedLong defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 68: {
                return UnsignedLong.ZERO;
            }
            case 83: {
                return (UnsignedLong)this._constructors[83].readValue();
            }
            case -128: {
                return (UnsignedLong)this._constructors[128].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected UnsignedLong type but found encoding: " + encodingCode);
    }

    @Override
    public Character readCharacter() {
        return this.readCharacter(null);
    }

    @Override
    public Character readCharacter(Character defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 115: {
                return (Character)this._constructors[115].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected Character type but found encoding: " + encodingCode);
    }

    @Override
    public char readCharacter(char defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 115: {
                return ((Character)this._constructors[115].readValue()).charValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new DecodeException("Expected Character type but found encoding: " + encodingCode);
    }

    @Override
    public Float readFloat() {
        return this.readFloat(null);
    }

    @Override
    public Float readFloat(Float defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 114: {
                return (Float)this._constructors[114].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new ProtonException("Expected Float type but found encoding: " + encodingCode);
    }

    @Override
    public float readFloat(float defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof FloatType.FloatEncoding) {
            return ((FloatType.FloatEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Float.class);
    }

    @Override
    public Double readDouble() {
        return this.readDouble(null);
    }

    @Override
    public Double readDouble(Double defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -126: {
                return (Double)this._constructors[130].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new ProtonException("Expected Double type but found encoding: " + encodingCode);
    }

    @Override
    public double readDouble(double defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof DoubleType.DoubleEncoding) {
            return ((DoubleType.DoubleEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Double.class);
    }

    @Override
    public UUID readUUID() {
        return this.readUUID(null);
    }

    @Override
    public UUID readUUID(UUID defaultVal) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -104: {
                return (UUID)this._constructors[152].readValue();
            }
            case 64: {
                return defaultVal;
            }
        }
        throw new ProtonException("Expected UUID type but found encoding: " + encodingCode);
    }

    @Override
    public Decimal32 readDecimal32() {
        return this.readDecimal32(null);
    }

    @Override
    public Decimal32 readDecimal32(Decimal32 defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 116: {
                return (Decimal32)this._constructors[116].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected Decimal32 type but found encoding: " + encodingCode);
    }

    @Override
    public Decimal64 readDecimal64() {
        return this.readDecimal64(null);
    }

    @Override
    public Decimal64 readDecimal64(Decimal64 defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -124: {
                return (Decimal64)this._constructors[132].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected Decimal64 type but found encoding: " + encodingCode);
    }

    @Override
    public Decimal128 readDecimal128() {
        return this.readDecimal128(null);
    }

    @Override
    public Decimal128 readDecimal128(Decimal128 defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -108: {
                return (Decimal128)this._constructors[148].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected Decimal128 type but found encoding: " + encodingCode);
    }

    @Override
    public Date readTimestamp() {
        return this.readTimestamp(null);
    }

    @Override
    public Date readTimestamp(Date defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -125: {
                return (Date)this._constructors[131].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected Timestamp type but found encoding: " + encodingCode);
    }

    @Override
    public Binary readBinary() {
        return this.readBinary(null);
    }

    @Override
    public Binary readBinary(Binary defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -96: {
                return (Binary)this._constructors[160].readValue();
            }
            case -80: {
                return (Binary)this._constructors[176].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected Binary type but found encoding: " + encodingCode);
    }

    @Override
    public Symbol readSymbol() {
        return this.readSymbol(null);
    }

    @Override
    public Symbol readSymbol(Symbol defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -93: {
                return (Symbol)this._constructors[163].readValue();
            }
            case -77: {
                return (Symbol)this._constructors[179].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected Symbol type but found encoding: " + encodingCode);
    }

    @Override
    public String readString() {
        return this.readString(null);
    }

    @Override
    public String readString(String defaultValue) {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -95: {
                return (String)this._constructors[161].readValue();
            }
            case -79: {
                return (String)this._constructors[177].readValue();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new ProtonException("Expected String type but found encoding: " + encodingCode);
    }

    @Override
    public List readList() {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case 69: {
                return Collections.EMPTY_LIST;
            }
            case -64: {
                return (List)this._constructors[192].readValue();
            }
            case -48: {
                return (List)this._constructors[208].readValue();
            }
            case 64: {
                return null;
            }
        }
        throw new ProtonException("Expected List type but found encoding: " + encodingCode);
    }

    @Override
    public <T> void readList(Decoder.ListProcessor<T> processor) {
    }

    @Override
    public Map readMap() {
        byte encodingCode = this._buffer.get();
        switch (encodingCode) {
            case -63: {
                return (Map)this._constructors[193].readValue();
            }
            case -47: {
                return (Map)this._constructors[209].readValue();
            }
            case 64: {
                return null;
            }
        }
        throw new ProtonException("Expected Map type but found encoding: " + encodingCode);
    }

    @Override
    public <T> T[] readArray(Class<T> clazz) {
        return null;
    }

    @Override
    public Object[] readArray() {
        return (Object[])this.readConstructor().readValue();
    }

    @Override
    public boolean[] readBooleanArray() {
        return (boolean[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public byte[] readByteArray() {
        return (byte[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public short[] readShortArray() {
        return (short[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public int[] readIntegerArray() {
        return (int[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public long[] readLongArray() {
        return (long[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public float[] readFloatArray() {
        return (float[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public double[] readDoubleArray() {
        return (double[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public char[] readCharacterArray() {
        return (char[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public <T> T[] readMultiple(Class<T> clazz) {
        Object val = this.readObject();
        if (val == null) {
            return null;
        }
        if (val.getClass().isArray()) {
            if (clazz.isAssignableFrom(val.getClass().getComponentType())) {
                return (Object[])val;
            }
            throw this.unexpectedType(val, Array.newInstance(clazz, 0).getClass());
        }
        if (clazz.isAssignableFrom(val.getClass())) {
            Object[] array = (Object[])Array.newInstance(clazz, 1);
            array[0] = val;
            return array;
        }
        throw this.unexpectedType(val, Array.newInstance(clazz, 0).getClass());
    }

    @Override
    public Object[] readMultiple() {
        Object val = this.readObject();
        if (val == null) {
            return null;
        }
        if (val.getClass().isArray()) {
            return (Object[])val;
        }
        Object[] array = (Object[])Array.newInstance(val.getClass(), 1);
        array[0] = val;
        return array;
    }

    @Override
    public byte[] readByteMultiple() {
        return new byte[0];
    }

    @Override
    public short[] readShortMultiple() {
        return new short[0];
    }

    @Override
    public int[] readIntegerMultiple() {
        return new int[0];
    }

    @Override
    public long[] readLongMultiple() {
        return new long[0];
    }

    @Override
    public float[] readFloatMultiple() {
        return new float[0];
    }

    @Override
    public double[] readDoubleMultiple() {
        return new double[0];
    }

    @Override
    public char[] readCharacterMultiple() {
        return new char[0];
    }

    @Override
    public Object readObject() {
        boolean arrayType = false;
        byte code = this._buffer.get(this._buffer.position());
        switch (code) {
            case -32: 
            case -16: {
                arrayType = true;
            }
        }
        TypeConstructor constructor = this.readConstructor();
        if (constructor == null) {
            throw new DecodeException("Unknown constructor");
        }
        if (arrayType) {
            return ((ArrayType.ArrayEncoding)constructor).readValueArray();
        }
        return constructor.readValue();
    }

    @Override
    public Object readObject(Object defaultValue) {
        Object val = this.readObject();
        return val == null ? defaultValue : val;
    }

    <V> void register(PrimitiveType<V> type) {
        Collection<PrimitiveTypeEncoding<V>> encodings = type.getAllEncodings();
        Iterator<PrimitiveTypeEncoding<V>> i$ = encodings.iterator();
        while (i$.hasNext()) {
            PrimitiveTypeEncoding<V> encoding;
            this._constructors[encoding.getEncodingCode() & 0xFF] = encoding = i$.next();
        }
    }

    byte readRawByte() {
        return this._buffer.get();
    }

    int readRawInt() {
        return this._buffer.getInt();
    }

    long readRawLong() {
        return this._buffer.getLong();
    }

    short readRawShort() {
        return this._buffer.getShort();
    }

    float readRawFloat() {
        return this._buffer.getFloat();
    }

    double readRawDouble() {
        return this._buffer.getDouble();
    }

    void readRaw(byte[] data, int offset, int length) {
        this._buffer.get(data, offset, length);
    }

    <V> V readRaw(TypeDecoder<V> decoder, int size2) {
        V decode = decoder.decode(this, (ByteBuffer)this._buffer.slice().limit(size2));
        this._buffer.position(this._buffer.position() + size2);
        return decode;
    }

    @Override
    public void setByteBuffer(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public ByteBuffer getByteBuffer() {
        return this._buffer;
    }

    CharsetDecoder getCharsetDecoder() {
        return this._charsetDecoder;
    }

    @Override
    public int getByteBufferRemaining() {
        return this._buffer.remaining();
    }

    private static class UnknownDescribedType
    implements DescribedType {
        private final Object _descriptor;
        private final Object _described;

        public UnknownDescribedType(Object descriptor, Object described) {
            this._descriptor = descriptor;
            this._described = described;
        }

        @Override
        public Object getDescriptor() {
            return this._descriptor;
        }

        @Override
        public Object getDescribed() {
            return this._described;
        }

        public boolean equals(Object obj) {
            return obj instanceof DescribedType && this._descriptor == null ? ((DescribedType)obj).getDescriptor() == null : (this._descriptor.equals(((DescribedType)obj).getDescriptor()) && this._described == null ? ((DescribedType)obj).getDescribed() == null : this._described.equals(((DescribedType)obj).getDescribed()));
        }
    }

    static interface TypeDecoder<V> {
        public V decode(DecoderImpl var1, ByteBuffer var2);
    }
}

