/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars.CarEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars.CarEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CarEntryBuilder
implements Builder<CarEntry> {
    private String _category;
    private CarId _id;
    private String _manufacturer;
    private String _model;
    private Long _year;
    private CarEntryKey key;
    Map<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> augmentation = Collections.emptyMap();

    public CarEntryBuilder() {
    }

    public CarEntryBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry arg) {
        this._id = arg.getId();
        this._model = arg.getModel();
        this._manufacturer = arg.getManufacturer();
        this._year = arg.getYear();
        this._category = arg.getCategory();
    }

    public CarEntryBuilder(CarEntry base) {
        Map aug;
        this.key = base.key();
        this._id = base.getId();
        this._category = base.getCategory();
        this._manufacturer = base.getManufacturer();
        this._model = base.getModel();
        this._year = base.getYear();
        if (base instanceof CarEntryImpl) {
            CarEntryImpl impl = (CarEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry) {
            this._id = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getId();
            this._model = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getModel();
            this._manufacturer = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getManufacturer();
            this._year = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getYear();
            this._category = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getCategory();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry]");
    }

    public CarEntryKey key() {
        return this.key;
    }

    public String getCategory() {
        return this._category;
    }

    public CarId getId() {
        return this._id;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public String getModel() {
        return this._model;
    }

    public Long getYear() {
        return this._year;
    }

    public <E$$ extends Augmentation<CarEntry>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public CarEntryBuilder withKey(CarEntryKey key) {
        this.key = key;
        return this;
    }

    public CarEntryBuilder setCategory(String value) {
        this._category = value;
        return this;
    }

    public CarEntryBuilder setId(CarId value) {
        this._id = value;
        return this;
    }

    public CarEntryBuilder setManufacturer(String value) {
        this._manufacturer = value;
        return this;
    }

    public CarEntryBuilder setModel(String value) {
        this._model = value;
        return this;
    }

    private static void checkYearRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public CarEntryBuilder setYear(Long value) {
        if (value != null) {
            CarEntryBuilder.checkYearRange(value);
        }
        this._year = value;
        return this;
    }

    public CarEntryBuilder addAugmentation(Class<? extends Augmentation<CarEntry>> augmentationType, Augmentation<CarEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CarEntryBuilder removeAugmentation(Class<? extends Augmentation<CarEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CarEntry build() {
        return new CarEntryImpl(this);
    }

    private static final class CarEntryImpl
    implements CarEntry {
        private final String _category;
        private final CarId _id;
        private final String _manufacturer;
        private final String _model;
        private final Long _year;
        private final CarEntryKey key;
        private Map<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        CarEntryImpl(CarEntryBuilder base) {
            this.key = base.key() != null ? base.key() : new CarEntryKey(base.getId());
            this._id = this.key.getId();
            this._category = base.getCategory();
            this._manufacturer = base.getManufacturer();
            this._model = base.getModel();
            this._year = base.getYear();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<CarEntry> getImplementedInterface() {
            return CarEntry.class;
        }

        @Override
        public CarEntryKey key() {
            return this.key;
        }

        @Override
        public String getCategory() {
            return this._category;
        }

        @Override
        public CarId getId() {
            return this._id;
        }

        @Override
        public String getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public String getModel() {
            return this._model;
        }

        @Override
        public Long getYear() {
            return this._year;
        }

        public <E$$ extends Augmentation<CarEntry>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._category);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._manufacturer);
            result = 31 * result + Objects.hashCode(this._model);
            result = 31 * result + Objects.hashCode(this._year);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CarEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CarEntry other = (CarEntry)obj;
            if (!Objects.equals(this._category, other.getCategory())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._manufacturer, other.getManufacturer())) {
                return false;
            }
            if (!Objects.equals(this._model, other.getModel())) {
                return false;
            }
            if (!Objects.equals(this._year, other.getYear())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CarEntryImpl otherImpl = (CarEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CarEntry");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_category", (Object)this._category);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_manufacturer", (Object)this._manufacturer);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_model", (Object)this._model);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_year", (Object)this._year);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

