/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StressTestInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StressTestInputBuilder
implements Builder<StressTestInput> {
    private Long _count;
    private Integer _rate;
    Map<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> augmentation = Collections.emptyMap();

    public StressTestInputBuilder() {
    }

    public StressTestInputBuilder(StressTestInput base) {
        Map aug;
        this._count = base.getCount();
        this._rate = base.getRate();
        if (base instanceof StressTestInputImpl) {
            StressTestInputImpl impl = (StressTestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>(aug);
        }
    }

    public Long getCount() {
        return this._count;
    }

    public Integer getRate() {
        return this._rate;
    }

    public <E$$ extends Augmentation<StressTestInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StressTestInputBuilder setCount(Long value) {
        if (value != null) {
            StressTestInputBuilder.checkCountRange(value);
        }
        this._count = value;
        return this;
    }

    private static void checkRateRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public StressTestInputBuilder setRate(Integer value) {
        if (value != null) {
            StressTestInputBuilder.checkRateRange(value);
        }
        this._rate = value;
        return this;
    }

    public StressTestInputBuilder addAugmentation(Class<? extends Augmentation<StressTestInput>> augmentationType, Augmentation<StressTestInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StressTestInputBuilder removeAugmentation(Class<? extends Augmentation<StressTestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StressTestInput build() {
        return new StressTestInputImpl(this);
    }

    private static final class StressTestInputImpl
    implements StressTestInput {
        private final Long _count;
        private final Integer _rate;
        private Map<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StressTestInputImpl(StressTestInputBuilder base) {
            this._count = base.getCount();
            this._rate = base.getRate();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StressTestInput> getImplementedInterface() {
            return StressTestInput.class;
        }

        @Override
        public Long getCount() {
            return this._count;
        }

        @Override
        public Integer getRate() {
            return this._rate;
        }

        public <E$$ extends Augmentation<StressTestInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._count);
            result = 31 * result + Objects.hashCode(this._rate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StressTestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StressTestInput other = (StressTestInput)obj;
            if (!Objects.equals(this._count, other.getCount())) {
                return false;
            }
            if (!Objects.equals(this._rate, other.getRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StressTestInputImpl otherImpl = (StressTestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StressTestInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_count", (Object)this._count);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_rate", (Object)this._rate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

