/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.IdGrouping;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StartPublishNotificationsInputBuilder
implements Builder<StartPublishNotificationsInput> {
    private String _id;
    private Long _notificationsPerSecond;
    private Long _seconds;
    Map<Class<? extends Augmentation<StartPublishNotificationsInput>>, Augmentation<StartPublishNotificationsInput>> augmentation = Collections.emptyMap();

    public StartPublishNotificationsInputBuilder() {
    }

    public StartPublishNotificationsInputBuilder(IdGrouping arg) {
        this._id = arg.getId();
    }

    public StartPublishNotificationsInputBuilder(StartPublishNotificationsInput base) {
        Map aug;
        this._id = base.getId();
        this._notificationsPerSecond = base.getNotificationsPerSecond();
        this._seconds = base.getSeconds();
        if (base instanceof StartPublishNotificationsInputImpl) {
            StartPublishNotificationsInputImpl impl = (StartPublishNotificationsInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StartPublishNotificationsInput>>, Augmentation<StartPublishNotificationsInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartPublishNotificationsInput>>, Augmentation<StartPublishNotificationsInput>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IdGrouping) {
            this._id = ((IdGrouping)arg).getId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.IdGrouping]");
    }

    public String getId() {
        return this._id;
    }

    public Long getNotificationsPerSecond() {
        return this._notificationsPerSecond;
    }

    public Long getSeconds() {
        return this._seconds;
    }

    public <E$$ extends Augmentation<StartPublishNotificationsInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public StartPublishNotificationsInputBuilder setId(String value) {
        this._id = value;
        return this;
    }

    private static void checkNotificationsPerSecondRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartPublishNotificationsInputBuilder setNotificationsPerSecond(Long value) {
        if (value != null) {
            StartPublishNotificationsInputBuilder.checkNotificationsPerSecondRange(value);
        }
        this._notificationsPerSecond = value;
        return this;
    }

    private static void checkSecondsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public StartPublishNotificationsInputBuilder setSeconds(Long value) {
        if (value != null) {
            StartPublishNotificationsInputBuilder.checkSecondsRange(value);
        }
        this._seconds = value;
        return this;
    }

    public StartPublishNotificationsInputBuilder addAugmentation(Class<? extends Augmentation<StartPublishNotificationsInput>> augmentationType, Augmentation<StartPublishNotificationsInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StartPublishNotificationsInput>>, Augmentation<StartPublishNotificationsInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StartPublishNotificationsInputBuilder removeAugmentation(Class<? extends Augmentation<StartPublishNotificationsInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartPublishNotificationsInput build() {
        return new StartPublishNotificationsInputImpl(this);
    }

    private static final class StartPublishNotificationsInputImpl
    implements StartPublishNotificationsInput {
        private final String _id;
        private final Long _notificationsPerSecond;
        private final Long _seconds;
        private Map<Class<? extends Augmentation<StartPublishNotificationsInput>>, Augmentation<StartPublishNotificationsInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StartPublishNotificationsInputImpl(StartPublishNotificationsInputBuilder base) {
            this._id = base.getId();
            this._notificationsPerSecond = base.getNotificationsPerSecond();
            this._seconds = base.getSeconds();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<StartPublishNotificationsInput> getImplementedInterface() {
            return StartPublishNotificationsInput.class;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public Long getNotificationsPerSecond() {
            return this._notificationsPerSecond;
        }

        @Override
        public Long getSeconds() {
            return this._seconds;
        }

        public <E$$ extends Augmentation<StartPublishNotificationsInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._notificationsPerSecond);
            result = 31 * result + Objects.hashCode(this._seconds);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StartPublishNotificationsInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StartPublishNotificationsInput other = (StartPublishNotificationsInput)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._notificationsPerSecond, other.getNotificationsPerSecond())) {
                return false;
            }
            if (!Objects.equals(this._seconds, other.getSeconds())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StartPublishNotificationsInputImpl otherImpl = (StartPublishNotificationsInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StartPublishNotificationsInput>>, Augmentation<StartPublishNotificationsInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"StartPublishNotificationsInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_notificationsPerSecond", (Object)this._notificationsPerSecond);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_seconds", (Object)this._seconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

