/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ops4j.pax.transx.jdbc.impl.ConnectionHandle;

final class Wrappers {
    private static final Set<Class<?>> CLASSES_TO_WRAP = new HashSet<Class>(Arrays.asList(Statement.class, PreparedStatement.class, CallableStatement.class, DatabaseMetaData.class, ResultSet.class));
    private static final Object UNHANLED = new Object();

    private Wrappers() {
    }

    static <H> H wrap(Class<H> clazz, ConnectionHandle c, H h) {
        return (H)Wrappers.wrap(clazz, c, h, Arrays.asList(Wrappers.wrapperIh(h), Wrappers.statementIh(c, h), Wrappers.getConnectionIh(c)));
    }

    private static Object wrap(Class<?> clazz, ConnectionHandle c, Object h, List<InvocationHandler> subHandlers) {
        if (h == null) {
            return null;
        }
        InvocationHandler ih = (proxy, method, args) -> {
            try {
                for (InvocationHandler sih : subHandlers) {
                    Object o = sih.invoke(proxy, method, args);
                    if (o == UNHANLED) continue;
                    return o;
                }
                Object result = method.invoke(h, args);
                if (CLASSES_TO_WRAP.contains(method.getReturnType())) {
                    result = Wrappers.wrap(method.getReturnType(), c, result, Arrays.asList(Wrappers.wrapperIh(result), Wrappers.statementIh(c, result), Wrappers.getConnectionIh(c)));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    c.connectionError((Exception)t);
                }
                throw e;
            }
        };
        return Proxy.newProxyInstance(h.getClass().getClassLoader(), new Class[]{clazz}, ih);
    }

    private static InvocationHandler getConnectionIh(ConnectionHandle c) {
        return (proxy, method, args) -> {
            if (method.getReturnType() == Connection.class && method.getName().equals("getConnection")) {
                return c;
            }
            return UNHANLED;
        };
    }

    private static InvocationHandler statementIh(ConnectionHandle c, Object h) {
        return (proxy, method, args) -> {
            if (Statement.class.isAssignableFrom(method.getDeclaringClass()) && ResultSet.class == method.getReturnType()) {
                Object ret = method.invoke(h, args);
                InvocationHandler getStatementIh = (proxy2, method2, args2) -> {
                    if (ResultSet.class.isAssignableFrom(method2.getDeclaringClass()) && method2.getName().equals("getStatement")) {
                        return proxy;
                    }
                    return UNHANLED;
                };
                return Wrappers.wrap(method.getReturnType(), c, ret, Arrays.asList(Wrappers.wrapperIh(ret), getStatementIh));
            }
            return UNHANLED;
        };
    }

    private static InvocationHandler wrapperIh(Object h) {
        return (proxy, method, args) -> {
            if (method.getDeclaringClass() == Wrapper.class) {
                switch (method.getName()) {
                    case "unwrap": {
                        if (((Class)args[0]).isInstance(h)) {
                            return ((Class)args[0]).cast(h);
                        }
                        return method.invoke(h, args);
                    }
                    case "isWrapperFor": {
                        if (((Class)args[0]).isInstance(h)) {
                            return true;
                        }
                        return method.invoke(h, args);
                    }
                }
            }
            return UNHANLED;
        };
    }
}

