/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.ops4j.pax.transx.connection.utils.SimpleConnectionManager;
import org.ops4j.pax.transx.connection.utils.UserPasswordConnectionRequestInfo;
import org.ops4j.pax.transx.connection.utils.UserPasswordConnectionRequestInfoImpl;
import org.ops4j.pax.transx.connection.utils.UserPasswordManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.AbstractJdbcManagedConnectionFactory;

public class TransxDataSource
implements DataSource,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(TransxDataSource.class.getName());
    protected final UserPasswordManagedConnectionFactory mcf;
    protected final ConnectionManager cm;

    public TransxDataSource(UserPasswordManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm != null ? cm : new SimpleConnectionManager();
    }

    @Override
    public void close() throws Exception {
        if (this.cm instanceof AutoCloseable) {
            ((AutoCloseable)this.cm).close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(UserPasswordConnectionRequestInfoImpl.NULL_CRI);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getConnection(new UserPasswordConnectionRequestInfoImpl(user, password));
    }

    private Connection getConnection(UserPasswordConnectionRequestInfo cri) throws SQLException {
        try {
            return (Connection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
        }
        catch (ResourceException e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        try {
            return this.mcf.getLogWriter();
        }
        catch (ResourceException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("Cannot set loginTimeout on a connection factory");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("Cannot set logWriter on a connection factory");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        DataSource ds;
        if (iface.isInstance(this)) {
            return true;
        }
        CommonDataSource cds = this.getUnwrappedDataSource();
        if (iface.isInstance(cds)) {
            return true;
        }
        return cds instanceof DataSource && (ds = (DataSource)cds).isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        DataSource ds;
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        CommonDataSource cds = this.getUnwrappedDataSource();
        if (iface.isInstance(cds)) {
            return iface.cast(cds);
        }
        if (cds instanceof DataSource && (ds = (DataSource)cds).isWrapperFor(iface)) {
            return ds.unwrap(iface);
        }
        throw new SQLException("Not a wrapper for " + iface.getName());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("org.ops4j.pax.transx");
    }

    private CommonDataSource getUnwrappedDataSource() {
        assert (this.mcf instanceof AbstractJdbcManagedConnectionFactory);
        return ((AbstractJdbcManagedConnectionFactory)this.mcf).dataSource;
    }
}

