/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ops4j.pax.transx.jdbc.impl.ConnectionWrapper;

public class PreparedStatementWrapper
implements PreparedStatement {
    private static final Logger LOG = Logger.getLogger(PreparedStatementWrapper.class.getName());
    private final PreparedStatement ps;
    private final ConnectionWrapper cw;
    private final String sql;
    private boolean statementClosed = false;
    private long lastTimeUsed = 0L;
    private long timesUsed = 0L;
    private long useCount = 0L;
    private long actualPrepareTime = 0L;

    public PreparedStatementWrapper(ConnectionWrapper cw, String sql, PreparedStatement ps, long prepareTime) {
        this.ps = ps;
        this.cw = cw;
        this.sql = sql;
        this.setActualPrepareTime(prepareTime);
    }

    @Override
    public void close() throws SQLException {
        this.ps.clearWarnings();
        this.ps.clearBatch();
        this.ps.clearParameters();
        this.cw.returnStatementToCache(this);
    }

    protected void closeStatement() {
        try {
            if (!this.statementClosed) {
                this.ps.close();
                this.statementClosed = true;
            }
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, "TRANQL DB2 EmbeddedXA Driver. Error closing PreparedStatement in closeStatement.\n  Error message = " + e.getMessage() + "\n     Error code = " + Integer.toString(e.getErrorCode()) + "       SQLState = " + e.getSQLState(), e);
        }
    }

    public long getActualPrepareTime() {
        return this.actualPrepareTime;
    }

    protected void setActualPrepareTime(long actualPrepareTime) {
        this.actualPrepareTime = actualPrepareTime;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    protected void updateLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    public long getTimesUsed() {
        return this.timesUsed;
    }

    protected long incrementTimesUsed() {
        return ++this.timesUsed;
    }

    protected void setTimesUsed(long timesUsed) {
        this.timesUsed = timesUsed;
    }

    public long getUseCount() {
        return this.useCount;
    }

    protected long incrementUseCount() {
        return ++this.useCount;
    }

    protected long decrementUseCount() {
        return --this.useCount;
    }

    protected synchronized void setUseCount(long useCount) {
        this.useCount = useCount;
    }

    public String toString() {
        String details = "                     SQL: " + this.sql + "\n          Last time used: " + new Date(this.lastTimeUsed).toString() + "\n    Number of times used: " + this.timesUsed + "\n    Current in Use Count: " + this.useCount + "\n    Initial Prepare time: " + this.actualPrepareTime + " milliseconds\n";
        return details;
    }

    public synchronized void checkOutStatement() {
        this.incrementTimesUsed();
        this.incrementUseCount();
        this.updateLastTimeUsed();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        this.ps.setFloat(arg0, arg1);
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.ps.setDouble(arg0, arg1);
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.ps.setBigDecimal(arg0, arg1);
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        this.ps.setString(arg0, arg1);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.ps.setBinaryStream(arg0, arg1, arg2);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream, long l) throws SQLException {
        this.ps.setAsciiStream(i, inputStream, l);
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream, long l) throws SQLException {
        this.ps.setBinaryStream(i, inputStream, l);
    }

    @Override
    public void setCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.ps.setCharacterStream(i, reader, l);
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream) throws SQLException {
        this.ps.setAsciiStream(i, inputStream);
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream) throws SQLException {
        this.ps.setBinaryStream(i, inputStream);
    }

    @Override
    public void setCharacterStream(int i, Reader reader) throws SQLException {
        this.ps.setCharacterStream(i, reader);
    }

    @Override
    public void setNCharacterStream(int i, Reader reader) throws SQLException {
        this.ps.setNCharacterStream(i, reader);
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        this.ps.setClob(i, reader);
    }

    @Override
    public void setBlob(int i, InputStream inputStream) throws SQLException {
        this.ps.setBlob(i, inputStream);
    }

    @Override
    public void setNClob(int i, Reader reader) throws SQLException {
        this.ps.setNClob(i, reader);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, time, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    @Override
    public void setRowId(int i, RowId rowId) throws SQLException {
        this.ps.setRowId(i, rowId);
    }

    @Override
    public void setNString(int i, String s) throws SQLException {
        this.ps.setNString(i, s);
    }

    @Override
    public void setNCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.ps.setNCharacterStream(i, reader, l);
    }

    @Override
    public void setNClob(int i, NClob nClob) throws SQLException {
        this.ps.setNClob(i, nClob);
    }

    @Override
    public void setClob(int i, Reader reader, long l) throws SQLException {
        this.ps.setClob(i, reader, l);
    }

    @Override
    public void setBlob(int i, InputStream inputStream, long l) throws SQLException {
        this.ps.setBlob(i, inputStream, l);
    }

    @Override
    public void setNClob(int i, Reader reader, long l) throws SQLException {
        this.ps.setNClob(i, reader, l);
    }

    @Override
    public void setSQLXML(int i, SQLXML sqlxml) throws SQLException {
        this.ps.setSQLXML(i, sqlxml);
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        return this.ps.executeQuery(arg0);
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        return this.ps.executeUpdate(arg0);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.ps.setMaxFieldSize(arg0);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.ps.setMaxRows(arg0);
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.ps.setEscapeProcessing(arg0);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.ps.setQueryTimeout(arg0);
    }

    @Override
    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        this.ps.setCursorName(arg0);
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        return this.ps.execute(arg0);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        this.ps.setFetchDirection(arg0);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.ps.setFetchSize(arg0);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        this.ps.addBatch(arg0);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        return this.ps.getMoreResults(arg0);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.ps.executeUpdate(arg0, arg1);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.ps.executeUpdate(arg0, arg1);
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.ps.executeUpdate(arg0, arg1);
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.ps.execute(arg0, arg1);
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.ps.execute(arg0, arg1);
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.ps.execute(arg0, arg1);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ps.isClosed();
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        this.ps.setPoolable(b);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ps.isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        return this.ps.unwrap(tClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        return this.ps.isWrapperFor(aClass);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ps.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.ps.isCloseOnCompletion();
    }
}

