/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command.completers;

import java.util.List;
import org.apache.karaf.docker.Container;
import org.apache.karaf.docker.DockerService;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

@Service
public class ContainersNameCompleter
implements Completer {
    @Reference
    private DockerService dockerService;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            for (Container container : this.dockerService.ps(true, null)) {
                for (String name : container.getNames()) {
                    delegate.getStrings().add(name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delegate.complete(session, commandLine, candidates);
    }

    public void setDockerService(DockerService dockerService) {
        this.dockerService = dockerService;
    }

    public DockerService getDockerService() {
        return this.dockerService;
    }
}

