/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.List;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ContainersNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="unpause", description="Unpause all processes within one or more containers")
@Service
public class UnpauseCommand
extends DockerCommandSupport {
    @Argument(index=0, name="container", description="Name or ID of the containers to unpause", required=true, multiValued=true)
    @Completion(value=ContainersNameCompleter.class)
    List<String> containers;

    public Object execute() throws Exception {
        for (String container : this.containers) {
            this.getDockerService().unpause(container, this.url);
        }
        return null;
    }
}

