/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.List;
import org.apache.karaf.docker.Top;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ContainersNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="top", description="Display the running processes of a container")
@Service
public class TopCommand
extends DockerCommandSupport {
    @Argument(index=0, name="container", description="Name or ID of the container", required=true, multiValued=false)
    @Completion(value=ContainersNameCompleter.class)
    String container;

    public Object execute() throws Exception {
        Top top = this.getDockerService().top(this.container, this.url);
        for (List<String> process : top.getProcesses()) {
            for (String p : process) {
                System.out.print(p + "\t");
            }
        }
        return null;
    }
}

